(function() {
    var errorText = iget2('b-email-notification', 'nevernoe-znachenie-urovnya-ostatka', 'Неверное значение уровня остатка средств');
    BEM.MODEL.decl('b-email-notification', {

        email: 'string',

        sendWarn: 'boolean',

        sendAccNews: 'boolean',

        /**
         * Процент от предыдущей отплаты, при достижении которого, будет отправлено предупреждение
         */
        money_warning_value: {
            type: 'number',
            precision: 0,
            validation: {
                rules: {

                    required: {
                        text: iget2('b-email-notification', 'neobhodimo-ukazat-uroven-ostatka', 'Необходимо указать уровень остатка средств')
                    },
                    type: {
                        text: errorText,
                        needToValidate: function() { return !!this.get('money_warning_value'); }
                    },
                    lte: {
                        value: 1,
                        text: errorText,
                        needToValidate: function() {
                            return !!this.get('money_warning_value') || this.get('money_warning_value') == 0;
                        }
                    },
                    gte: {
                        value: u.consts('MAX_MONEY_WARNING_VALUE') || 50,
                        text: errorText,
                        needToValidate: function() { return !!this.get('money_warning_value'); }
                    }
                }
            }
        },

        warnPlaceInterval: 'string',

        offlineStatNotice: 'boolean',

        email_notify_paused_by_day_budget: {
            type: 'number',
            calculate: function() {

                return this.get('pausedByDayBudgetCheckboxState') ? 1 : 0;
            }
        },

        pausedByDayBudgetCheckboxState: 'boolean'
    })
}());
