block('b-email-select')(

    elem('select-block').content()(function() {
        return [
            {
                block: 'b-email-select',
                elem: 'select',
                email: this.ctx.email,
                validEmails: this.ctx.validEmails
            }
        ];
    }),

    elem('add-btn').replace()(function() {
        return {
            block: 'icon-text',
            mods: { theme: 'plus', size: 'xs' },
            mix: { block: 'b-email-select', elem: 'add-btn' },
            text: iget2('b-email-select', 'dobavit-novyy', 'добавить новый')
        };
    }),

    elem('select').replace()(function() {
        return {
            block: 'select',
            mods: { layout: 'content', width: '400' },
            mix: [{ block: 'b-email-select', elem: 'select' }],
            content: [
                {
                    block: 'button',
                    content: u.escapeHTML(this.ctx.email) || '&nbsp;',
                    mix: [{ block: 'b-email-select', elem: 'select-button' }]
                },
                {
                    elem: 'control',
                    content: this.ctx.validEmails.map(function(val) {
                        var attrs = { value: val.email };

                        if (this.ctx.email == val.email) attrs.selected = 'yes';

                        return {
                            block: 'select',
                            elem: 'option',
                            attrs: attrs,
                            content: u.escapeHTML(val.email)
                        }
                    }, this)
                }
            ]
        }
    }),

    elem('popup-block').content()(function() {
        return {
            block: 'popup',
            js: { directions: 'bottom' },
            mix: [{ block: 'b-email-select', elem: 'popup' }],
            mods: { 'has-close': 'yes', adaptive: 'no', theme: 'ffffff' },
            content: [
                {
                    elem: 'tail'
                },
                {
                    elem: 'content',
                    content: {
                        block: 'b-email-select',
                        elem: 'content',
                        content: [
                            {
                                elem: 'email-error'
                            },
                            {
                                block: 'input',
                                content: { elem: 'control' },
                                mix: [
                                    {
                                        block: 'b-email-select',
                                        elem: 'email'
                                    },
                                    {
                                        block: 'b-email-select',
                                        elem: 'model-field',
                                        js: {
                                            type: 'input',
                                            name: 'email'
                                        }
                                    }
                                ]
                            },
                            {
                                block: 'button',
                                mix: [{ block: 'b-email-select', elem: 'ok' }],
                                content: iget2('b-email-select', 'dobavit-105', 'Добавить')
                            },
                            {
                                block: 'button',
                                mix: [{ block: 'b-email-select', elem: 'cancel' }],
                                content: iget2('b-email-select', 'otmena', 'Отмена')
                            }
                        ]
                    }
                }
            ]
        };
    })
);
