BEM.DOM.decl({ name: 'b-email-select', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                save: 'button on ok',
                cancel: 'button on cancel',
                email: 'input on email',
                select: 'select on select',
                popup: 'popup inside',
                parentPopup: '? popup outside'
            });

            this.options = this.params.options;
            this.popup
                .on('show', function() {
                    this.parentPopup && this.parentPopup.on('outside-click', function(e) { e.preventDefault() });
                    this.email.val('');
                    this.setMod(this._content, 'error', 'no');
                }, this)
                .on('hide', function() {
                    this.afterCurrentEvent(function() {
                        this.parentPopup && this.parentPopup.un('outside-click');
                    })
                }, this);

            this._emailError = this.elem('email-error');
            this._content = this.elem('content');

            this.__base.apply(this, arguments);

            this.model.fix();

            this.model.on('email', 'error', this.onError, this);

            this.save.on('click', this.onSubmit, this);
            this.cancel.on('click', this.onCancel, this);

            this.bindTo('add-btn', 'click', function() {
                this.popup.toggle(this.elem('add-btn'))
            });

            this.email.on('change', function() { this.setMod('error', 'no') }, this);

            this.select.on('change', this.onChange, this);

            this.parentPopup && this.parentPopup.on('show', this.onChange, this);
        }
    },

    val: function(value) {
        this.select.val(value);
    },

    onChange: function() {
        this.trigger('change', { val: this.select.val() });
    },

    onCancel: function(e) {
        this.popup.hide();
    },

    onSubmit: function(e) {
        e.preventDefault();
        if (this.model.isValid()) {
            this.onNewEmail();
            this.popup.hide();
        }
    },

    onError: function(e, error) {
        this.setMod(this._content, 'error', 'yes');
        this._emailError.html(error.text);
    },

    declineChange: function() {
        this.model.rollback();
    },

    onNewEmail: function() {
        var newEmail = this.model.get('email');

        this.popup.hide();
        this.options.push({
            item: 'option',
            selected: true,
            value: newEmail,
            content: newEmail
        });

        this.select.setOptions(this.options);

        this.model.fix();
        this.trigger('change', { val: newEmail });
    }

});
