block('b-enable-wallet')(
    addJs()(true),

    content()(function() {
        var data = this.data,
            wallet = this.ctx.wallet,
            buttons = this.ctx.buttons,
            form = data.FORM;

        return [
            {
                block: 'b-enable-wallet',
                elem: 'cmd'
            },
            {
                block: 'b-enable-wallet',
                elem: 'servicing',
                value: u.escapeHTML(form.servicing)
            },
            {
                block: 'b-enable-wallet',
                elem: 'csrf-token',
                value: data.csrf_token
            },
            !!form.ulogin && {
                block: 'b-enable-wallet',
                elem: 'ulogin',
                value: u.escapeHTML(form.ulogin)
            },
            !!form.AgencyID && {
                block: 'b-enable-wallet',
                elem: 'agency-id',
                value: form.AgencyID
            },
            !!wallet.total && {
                block: 'b-wallet-info',
                wallet: wallet
            },
            {
                block: 'b-enable-wallet',
                elem: 'block',
                content: iget2(
                    'b-enable-wallet',
                    'obshchiy-schyot-eto-sposob',
                    'Общий счёт - это способ автоматического распределения средств между всеми активными кампаниями аккаунта. {link}',
                    {
                        link: function(text) {
                            return {
                                block: 'link',
                                attrs: {
                                    target: '_blank'
                                },
                                url: u.getCommonHelpUrl('/direct-tooltips/shared-account.xml'),
                                content: text
                            };
                        }(iget2('b-enable-wallet', 'obshchiy-schyot-eto-sposob-param-link', 'Подробнее')),

                        context: 'link - Подробнее'
                    }
                )
            },
            {
                block: 'b-enable-wallet',
                elem: 'block',
                mix: [{
                    block: 'b-enable-wallet',
                    elem: 'title'
                }],
                content: iget2('b-enable-wallet', 'pri-podklyuchenii-obshchego-schyota', 'При подключении общего счёта') + ':'
            },
            {
                block: 'b-enable-wallet',
                elem: 'block',
                content: {
                    elem: 'ul',
                    content: [
                        iget2(
                            'b-enable-wallet',
                            'vse-imeyushchiesya-na-kampaniyah',
                            'все имеющиеся на кампаниях средства будут перенесены на общий счёт;'
                        ),
                        iget2(
                            'b-enable-wallet',
                            'dengi-budut-raspredelyatsya-po',
                            'деньги будут распределяться по всем кампаниям автоматически согласно установленным ограничениям;'
                        ),
                        iget2(
                            'b-enable-wallet',
                            'stanet-dostupnoy-opciya-ogranicheniya',
                            'станет доступной опция ограничения дневного бюджета на кампанию;'
                        ),
                        iget2('b-enable-wallet', 'zachislenie-sredstv-budet-vozmozhno', 'зачисление средств будет возможно только на общий счёт;'),
                        iget2(
                            'b-enable-wallet',
                            'uvedomleniya-ob-ostatke-sredstv',
                            'уведомления об остатке средств будут содержать информацию о состоянии общего счёта.'
                        )
                    ].map(function(text) {
                        return {
                            elem: 'li',
                            content: text
                        };
                    })
                }
            },
            {
                block: 'b-enable-wallet',
                elem: 'block',
                mix: [{
                    block: 'b-enable-wallet',
                    elem: 'title'
                }],
                content: iget2(
                    'b-enable-wallet',
                    'otklyuchit-os-nelzya',
                    'Отключить общий счёт нельзя!'
                )
            },
            {
                block: 'b-enable-wallet',
                elem: 'block',
                mix: { block: 'b-enable-wallet', elem: 'controls' },
                content: [
                    {
                        block: 'spin',
                        mods: { theme: 'gray-16' },
                        mix: [{
                            block: 'b-enable-wallet',
                            elem: 'spin'
                        }]
                    },
                    {
                        block: 'button',
                        mods: { theme: 'action' },
                        content: iget2('b-enable-wallet', 'podklyuchit-obshchiy-schyot', 'Подключить общий счёт'),
                        type: 'submit',
                        mix: [
                            {
                                block: 'b-enable-wallet',
                                elem: 'button'
                            }
                        ]
                    }
                ]
                    .concat(buttons)
                    .map(function(button) {
                        button.mix = (button.mix || []).concat([{ block: 'b-enable-wallet', elem: 'control' }]);
                        return button;
                    })
            }
        ];
    })
);
