/**
 * @property {GroupSummaryCtx} this.ctx
 */
block('b-error-groups-summary-body')(
    content()(function() {
        return [
            {
                elem: 'message',
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-16': 'alert' },
                        mix: [{
                            block: 'b-form-errors-header',
                            elem: 'notice'
                        }]
                    },
                    '&nbsp;',
                    iget2(
                        'b-error-groups-summary-body',
                        'pozhaluysta-zapolnite-pravilno-neobhodimye',
                        'Пожалуйста, заполните правильно необходимые поля'
                    )
                ]
            },
            {
                elem: 'errors-list-wrapper',
                content: {
                    elem: 'errors-list',
                    generic: this.ctx.generic || [],
                    banners: this.ctx.banners || [],
                    groups: this.ctx.groups || [],
                    title: this.ctx.title || []
                }
            }
        ];
    }),

    elem('errors-list').content()(function() {
        return [
            !!(this.ctx.generic.length) && {
                elem: 'sub-message',
                content: this.ctx.generic.map(function(err) {
                    return err.text;
                }, this)
            },

            !!(this.ctx.groups.length) && {
                elem: 'sub-message',
                content: [
                    iget2('b-error-groups-summary-body', 'oshibki-v-nastroykah-grupp', 'Ошибки в настройках групп') + ':',
                    this.ctx.groups.map(function(group, i) {
                        return [
                            i == 0 ? ' ' : ', ',
                            {
                                elem: 'group-link',
                                elemMods: { type: 'properties' },
                                group: group,
                                url: '#Group-properties-' + group.modelId
                            }
                        ];
                    }, this)
                ]
            },

            !!(this.ctx.title.length) && {
                elem: 'sub-message',
                content: [
                    iget2('b-error-groups-summary-body', 'ne-ukazano-nazvanie-gruppy', 'Не указано название группы') + ':',
                    this.ctx.title.map(function(group, i) {
                        return [
                            i == 0 ? ' ' : ', ',
                            {
                                elem: 'group-link',
                                elemMods: { type: 'title' },
                                url: '#Group-' + group.modelId,
                                group: group
                            }
                        ];
                    }, this)
                ]
            },

            !!(this.ctx.banners.length) && {
                elem: 'sub-message-banners',
                mix: { elem: 'sub-message' },
                banners: this.ctx.banners
            }
        ];
    }),

    elem('sub-message-banners').content()(function() {
        return [
            iget2('b-error-groups-summary-body', 'oshibki-v-obyavleniyah', 'Ошибки в объявлениях') + ':',
            this.ctx.banners.map(function(data, i) {
                return [
                    i == 0 ? ' ' : ', ',
                    {
                        elem: 'banner-link',
                        banner: data.banner,
                        group: data.group
                    }
                ];
            })
        ];
    }),

    elem('group-link').def()(function() {
        return applyCtx({
            block: 'link',
            url: this.ctx.url,
            content: applyCtx({
                elem: 'group-name',
                banner: this.ctx.banner,
                group: this.ctx.group
            })
        });
    }),

    elem('banner-link').def()(function() {
        return applyCtx({
            block: 'link',
            url: '#Banner-' + this.ctx.group.modelId + '-' + this.ctx.banner.modelId,
            content: applyCtx([
                {
                    elem: 'banner-name',
                    banner: this.ctx.banner,
                    group: this.ctx.group
                },
                !this.ctx.group.isSingleGroup && [
                    ' (' + iget2('b-error-groups-summary-body', 'gruppa', 'группа'),
                    '&nbsp;',
                    {
                        elem: 'group-name',
                        banner: this.ctx.banner,
                        group: this.ctx.group
                    },
                    ')'
                ]
            ])
        });
    }),

    elem('banner-name')(
        tag()('span'),
        content()(function() {
            return this.ctx.banner.isNewBanner ?
                iget2('b-error-groups-summary-body', 'novoe-obyavlenie', 'Новое объявление') + ' ' + this.ctx.banner.newBannerIndex :
                '№ M-' + this.ctx.banner.bid;
        })
    ),

    elem('group-name')(
        tag()('span'),
        content()(function() {
            return (this.ctx.group.isNewGroup || this.ctx.group.isCopyGroup) ? iget2('b-error-groups-summary-body', 'novaya-gruppa-s', 'Новая группа {foo}', {
                foo: this.ctx.group.newGroupIndex
            }) : '№ ' + this.ctx.group.modelId;
        })
    )
);
