/**
 * @typedef {Object} GroupSummaryCtx
 * @property { { text: String }[] } generic
 * @property {GroupSummaryData[]} title
 * @property {GroupSummaryData[]} groups
 * @property { { group: <GroupSummaryData>, banner: <BannerSummaryData> } } banners
 */

/**
 * @property {GroupSummaryCtx} this.ctx
 */
block('b-error-groups-summary')(
    content()(function() {
        return {
            elem: 'body',
            generic: this.ctx.generic,
            title: this.ctx.title,
            groups: this.ctx.groups,
            banners: this.ctx.banners
        };
    }),

    elem('body').replace()(function() {
        return {
            block: 'b-error-groups-summary-body',
            mix: { block: 'b-error-groups-summary', elem: 'body' },
            generic: this.ctx.generic || [],
            banners: this.ctx.banners || [],
            groups: this.ctx.groups || [],
            title: this.ctx.title || []
        };
    })
);
