/**
 * Блок отображения сообщения с текстом ошибок + заголовком, призывающим всё исправить
 * @implements IErrorViewInterface
 */
BEM.DOM.decl({ block: 'b-error-groups-summary', implements: 'i-error-view-interface' }, {

    /**
     * Показывает ошибки
     * @param {GroupSummaryCtx[]} errors
     */
    showErrors: function(errors) {
        var errorsHash = errors[0]; //summary всегда один

        BEM.DOM.replace(this.findElem('body'), this._getBody(errorsHash));

        this.setMod('visible', 'yes');
    },

    /**
     * Сбрасывает ошибки
     */
    clearErrors: function() {
        BEM.DOM.update(this.findElem('body'), '');

        this.delMod('visible');
    },

    /**
     * Возвращает html содержимого
     * @param {Object} errorsHash хэш ошибок
     * @returns {BEM.DOM}
     * @private
     */
    _getBody: function(errorsHash) {
        return BEMHTML.apply({
            block: 'b-error-groups-summary-body',
            mix: { block: 'b-error-groups-summary', elem: 'body' },
            generic: errorsHash.generic,
            title: errorsHash.title,
            groups: errorsHash.groups,
            banners: errorsHash.banners
        });
    }

});
