/**
 * Плоский хэш ошибок вида {String field: CommonErrorData[] errors}
 * Ключом является путь ошибки вида groups[0].performance_filters[0].condition
 * Значением является список объектов ошибок
 * @typedef {Object} FlatErrorsHash
 * @see IErrorViewInterface
 */

BEM.DOM.decl('b-error-presenter', {

    /**
     * Показывает переданные ошибки, делегируя логику показа блокам обработки ошибок
     * @param {FlatErrorsHash} errors
     */
    showErrors: function(errors) {
        var errorsHash = {},
            blocksHash = u._.groupBy(this.findBlocksByInterfaceInside('i-error-view-interface'), function(block) {
                return block.params.path;
            }),
            /**
             * Собирает данные об ошибках в плоский комбинированный список
             * Ошибки без прямого блока отображения будут прокидываться "вверх" для отображения
             * @param {Object[]} errorData список объектов ошибок
             * @param {String} errorPath ключ-путь ошибки вида groups[0].performance_filters[0].condition
             */
            collect = function(errorData, errorPath) {
                var superKey;

                if (errorPath in blocksHash) {
                    // если существует блок вывода ошибок, то сохраняем данные об ошибках в хэш
                    errorsHash[errorPath] = [].concat(errorsHash[errorPath] || [], errorData);
                } else {
                    // если не существует блок вывода ошибок, то "взбираемся" на уровень выше для поиска
                    superKey = errorPath.replace(/^(.+)(\[\d+?]|\.).*$/, function(str, sub) { return sub; });

                    // если есть куда "взбираться"
                    superKey != errorPath && collect(errorData, superKey);
                }
            };

        // проходим по отсортированным ключам (для сохранения приоритетности общих ошибок над частными детализированными)
        u._.keys(errors).sort().forEach(function(errorPath) {
            errorPath && collect(errors[errorPath], errorPath);
        });

        // исключаем блоки, для которых не передано ошибок
        blocksHash = u._.pick(blocksHash, u._.keys(errorsHash));

        // проход по результирующему хэшу ошибок, в который собраны и ошибки имеющие прямой блок обработки, и те
        // ошибки которые не имея своего блока отображения должны быть обработаны блоками более высокого уровня
        u._.forOwn(errorsHash, function(errors, errorPath) {
            blocksHash[errorPath].forEach(function(block) {
                block.showErrors(errors);
            });
        });

        this._blocksHash = u._.extend(blocksHash, this._blocksHash);
    },

    /**
     * Сбрасывает указанную (и "дочерние") или все ошибки, делегируя логику сброса блокам обработки ошибок
     * @param {String} [errorPath] путь ошибки, которую надо сбросить вместе с "дочерними"
     * @returns {String[]} отсортированный список ключей оставшихся ошибок
     */
    clearErrors: function(errorPath) {
        var clearEverything = !arguments.length;

        // исключаем и очищаем ошибки либо у всех блоков
        // либо у тех чьи, ключи начинаются на errorPath
        this._blocksHash = u._.omit(this._blocksHash, function(blocks, path) {
            var clear = clearEverything || path.indexOf(errorPath) === 0;

            clear && blocks.forEach(function(block) {
                // блок мог быть удалён из DOM
                block.domElem && block.clearErrors();
            });

            return clear;
        });

        return u._.keys(this._blocksHash).sort();
    }

}, {

    live: true

});
