BEM.DOM.decl({ block: 'b-ess-status' }, {
    onSetMod: {
        js: function() {
            this.updateStatus();
        }
    },
    /**
     * Рэндерит компонент ess статуса
     */
    updateStatus: function() {
        var dna = window.dna,
            params = this.params,
            campaignId = params.campaignId,
            campaignStartDate = params.campaignStartDate,
            campaignEndDate = params.campaignEndDate,
            that = this;

        if (!dna) {
            return;
        }

        dna.utils.getESSStatusInfo(u.consts('ulogin'), this.params.campaignId)
            .then(function(response) {
                if (response.data) {
                    var campaignData = response.data.client.campaigns.rowset[0],
                        statusInfo = dna.utils.mapESSStatusInfoFromApiFormat(
                            campaignData.aggregatedStatusInfo
                        ),
                        timeTargetingSettings =
                            dna.utils.mapTimeTargetingSettingsFromApiFormat(campaignData.status.timeTargetStatus);

                    dna.reactDOMRender(
                        dna.reactCreateElement(dna.components.ESSStatus, {
                            status: statusInfo.status,
                            reasons: statusInfo.reasons,
                            hasChildrenWithProblems: statusInfo.hasChildrenWithProblems,
                            childrenInfo: statusInfo.childrenInfo,
                            counters: statusInfo.counters,
                            hasRejectReasons: statusInfo.hasRejectReasons,
                            campaignStartTime: campaignStartDate,
                            campaignFinishTime: campaignEndDate,
                            timeTargetingSettings: timeTargetingSettings,
                            id: campaignId,
                            campaignId: campaignId,
                            showDetails: false
                        }),
                        that.domElem[0]
                    );
                }
            })
            .catch(function() {});
    }
});
