BEM.DOM.decl('b-expander', {

    onSetMod: {

        open: {
            yes: function() {
                this._open();

            },
            '': function() {
                this._close();
            }
        }

    },

    _open: function() {
        this.trigger('open');
        this.elem('body').slideDown({
            progress: function() {
                $(window).trigger('resize'); // DIRECT-72649
            }
        });
    },

    _close: function() {
        this.trigger('close');
        this.elem('body').slideUp({
            progress: function() {
                $(window).trigger('resize'); // DIRECT-72649
            }
        });
    },

    setSubtitle: function(content) {
        BEM.DOM.update(this.elem('subtitle'), BEMHTML.apply(content));
    },

    setBody: function(content) {
        BEM.DOM.update(this.elem('body'), BEMHTML.apply(content));
    }

}, {

    live: function() {

        this
            .liveBindTo('header expander-icon', 'click', function(e) {
                this.toggleMod('open', 'yes');
            })
            .liveBindTo('ignore-event', 'click', function(e) {
                e.stopPropagation();
            });
    }
});
