block('b-experiment-info')(

    js()(function() {
        return {
            experimentId: (this.ctx.exp || {}).experimentId
        };
    }),

    elem('label').tag()('span'),

    content()(function() {
        var exp = this.ctx.exp || {};

        return [
            {
                elem: 'line',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-experiment-info', 'kampaniya-a', 'Кампания A') + ':&nbsp;'
                    },
                    u.formatString('%s - %s (%s%)', exp.cid1, exp.name1, exp.percent)
                ]
            },
            {
                elem: 'line',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-experiment-info', 'kampaniya-b', 'Кампания B') + ':&nbsp;'
                    },
                    u.formatString('%s - %s (%s%)', exp.cid2, exp.name2, 100 - exp.percent)
                ]
            },
            {
                elem: 'line',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-experiment-info', 'period', 'Период') + ':&nbsp;'
                    },
                    u['b-date-range-picker'].prettifyPeriod(exp.from, exp.to)
                ]
            },
            this.ctx.hasActions && {
                elem: 'actions',
                content: {
                    block: 'button',
                    mix: { block: 'b-experiment-info', elem: 'button' },
                    mods: { size: 's' },
                    content: iget2('b-experiment-info', 'ostanovit-eksperiment', 'Остановить эксперимент')
                }
            }
        ];
    })
);
