BEM.DOM.decl('b-experiment-info', {
    onSetMod: {
        js: function() {
            this._button = this.findBlockOn('button', 'button');
            this._button && this._button.on('click', this._confirmAndStop, this);
        }
    },

    _confirmAndStop: function() {
        BEM.blocks['b-confirm'].open({
            message: iget2(
                'b-experiment-info',
                'eksperiment-budet-zavershen-kampanii',
                'Эксперимент будет завершен. Кампании, участвующие в эксперименте,\nпродолжат работать на 100% аудитории.'
            ),
            textYes: iget2('b-experiment-info', 'zavershit', 'Завершить'),
            textNo: iget2('b-experiment-info', 'otmena', 'Отмена'),
            onYes: this._sendRequest.bind(this)
        });
    },

    _showError: function(message) {
        BEM.blocks['b-confirm'].alert(message);
        this._button.delMod('disabled');
    },

    _sendRequest: function() {
        this._button.setMod('disabled', 'yes');

        BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
            params: {
                showCamp: {
                    experiment: 'stop'
                }
            }
        });

        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            type: 'POST',
            cache: false,
            callbackCtx: this
        }).get({
            cmd: 'ajaxStopExperiment',
            experiment_id: this.params.experimentId,
            ulogin: u.consts('ulogin')
        },
        function(res) {
            res.error ? this._showError(res.error) : location.reload();
        },
        function() {
            this._showError(iget2('b-experiment-info', 'oshibka-pri-sozdanii-eksperimenta', 'Ошибка при создании эксперимента. Попробуйте еще раз.'));
        });
    },

    destruct: function() {
        this._button && this._button.un('click');
        this.__base.apply(this, arguments);
    }
});
