block('b-experiment-list')(
    content()(function() {
        var experiments = this.ctx.experiments,
            campaigns = this.ctx.campaigns.reduce(function(obj, campaign) {
                obj[campaign.cid] = campaign;

                return obj;
            }, {}),
            states = {
                New: iget2('b-experiment-list', 'novyy', 'Новый'),
                Started: iget2('b-experiment-list', 'nachat', 'Начат'),
                Stopped: iget2('b-experiment-list', 'zavershyon', 'Завершён')
            };

        return [
            {
                elem: 'title',
                tag: 'h2',
                content: iget2('b-experiment-list', 'spisok-ab-testov', 'Список AB-тестов')
            },
            {
                block: 'b-data-table',
                mods: { sortable: 'server' },
                mix: [
                    { block: 'b-style-table', mods: { theme: 'gray-list' } }
                ],
                columns: [
                    {
                        key: 'created',
                        title: iget2('b-experiment-list', 'sozdan', 'Создан'),
                        transformData: function(row) {
                            return u.moment(row.create_time, 'YYYY-MM-DD HH:mm:ss').format('D MMMM YYYY, H:mm');
                        }
                    },
                    {
                        key: 'primary_cid',
                        title: iget2('b-experiment-list', 'kampanii', 'Кампании'),
                        sortDisable: true,
                        transformData: function(row) {
                            var formatCampaignName = function(cid) {
                                return campaigns[cid] ?
                                    campaigns[cid].name :
                                {
                                    block: 'b-experiment-list',
                                    elem: 'absent-title',
                                    content: iget2('b-experiment-list', 'kampaniya-udalena', 'Кампания удалена')
                                };
                            };

                            return [
                                {
                                    elem: 'line',
                                    content: [
                                        'A: ',
                                        formatCampaignName(row.primary_cid),
                                        ' (',
                                        row.primary_cid,
                                        ')',
                                        ' (',
                                        row.percent,
                                        '%)'
                                    ]
                                },
                                {
                                    elem: 'line',
                                    content: [
                                        'B: ',
                                        formatCampaignName(row.secondary_cid),
                                        ' (',
                                        row.secondary_cid,
                                        ')',
                                        ' (',
                                        (100 - row.percent),
                                        '%)'
                                    ]
                                }
                            ];
                        }
                    },
                    {
                        key: 'period',
                        title: iget2('b-experiment-list', 'testovyy-period', 'Тестовый период'),
                        sortDisable: true,
                        transformData: function(row) {
                            return u['b-date-range-picker'].prettifyPeriod(row.date_from, row.date_to);
                        }
                    },
                    {
                        key: 'state',
                        title: iget2('b-experiment-list', 'status', 'Статус'),
                        sortDisable: true,
                        transformData: function(row) {
                            return states[row.status] +
                                (row.stop_time ? ' ' + u.moment(row.stop_time).format('HH:mm D MMMM YYYY') : '');
                        }
                    }
                ],
                rows: Object.keys(experiments).map(function(key) {
                    return experiments[key];
                }),
                mixes: {
                    row: [{ block: 'b-style-table', elem: 'row' }],
                    headerRow: [{ block: 'b-style-table', elem: 'head' }],
                    cell: [{ block: 'b-style-table', elem: 'cell' }],
                    headerCell: [{ block: 'b-style-table', elem: 'cell' }]
                }
            }
        ];
    })
);
