block('b-experiment-params')(
    js()(function() {
        return {
            campaigns: this.ctx.campaigns
        };
    }),

    mix()({
        block: 'i-glue',
        js: { modelName: 'b-experiment-params' }
    }),

    content()(function() {
        var defaultPercent = 50,
            range = 90,
            dateFormat = 'YYYY-MM-DD',
            minDate = u.moment().add(1, 'd').format(dateFormat),
            campaigns = this.ctx.campaigns;

        return [
            {
                elem: 'row',
                elemMods: { type: 'campaign-a' },
                content: [
                    {
                        elem: 'cell',
                        content: [
                            {
                                elem: 'item',
                                elemMods: { type: 'label' },
                                content: iget2('b-experiment-params', 'kampaniya-a', 'Кампания A') + ':'
                            },
                            {
                                elem: 'item',
                                content: {
                                    block: 'b-campaigns-select',
                                    mix: [
                                        {
                                            block: 'b-experiment-params',
                                            elem: 'campaign-select',
                                            elemMods: { campaign: 'a' }
                                        },
                                        {
                                            block: 'b-experiment-params',
                                            elem: 'model-field',
                                            js: {
                                                name: 'primaryCid',
                                                type: 'select'
                                            }
                                        }
                                    ],
                                    inputHint: iget2('b-experiment-params', 'nayti-po-nomeru-ili', 'Найти по номеру или названию'),
                                    emptyHint: iget2('b-experiment-params', 'net-kampaniy-sootvetstvuyushchih-filtru', 'Нет кампаний, соответствующих фильтру'),
                                    defaultText: u['b-campaigns-select'].EMPTY_TEXT,
                                    name: 'cid',
                                    campaigns: campaigns,
                                    disabledCampaigns: u['b-experiment-params'].getDisabledCampaigns(campaigns),
                                    addEmpty: true,
                                    selectNone: true
                                }
                            }
                        ]
                    },
                    {
                        elem: 'cell',
                        elemMods: { side: 'right' },
                        content: [
                            {
                                elem: 'item',
                                content: iget2('b-experiment-params', 'procent-auditorii', 'Процент аудитории') + ':'
                            },
                            {
                                elem: 'item',
                                elemMods: { type: 'percent-input' },
                                content: {
                                    block: 'input',
                                    mix: [
                                        {
                                            block: 'b-experiment-params',
                                            elemMods: 'percent-input',
                                            mods: { campaign: 'a' }
                                        },
                                        {
                                            block: 'b-experiment-params',
                                            elem: 'model-field',
                                            js: {
                                                name: 'primaryPercent',
                                                type: 'input'
                                            }
                                        }
                                    ],
                                    content: { elem: 'control' },
                                    value: defaultPercent
                                }
                            },
                            {
                                elem: 'item',
                                elemMods: { type: 'percent-text' },
                                content: {
                                    elem: 'percent-text',
                                    elemMods: { campaign: 'a' },
                                    mix: {
                                        block: 'b-experiment-params',
                                        elem: 'model-field',
                                        js: {
                                            name: 'primaryPercent',
                                            type: 'inline'
                                        }
                                    },
                                    content: defaultPercent
                                }
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'row',
                elemMods: { type: 'campaign-b' },
                content: [
                    {
                        elem: 'cell',
                        content: [
                            {
                                elem: 'item',
                                elemMods: { type: 'label' },
                                content: iget2('b-experiment-params', 'kampaniya-b', 'Кампания B') + ':'
                            },
                            {
                                elem: 'item',
                                content: {
                                    block: 'b-campaigns-select',
                                    mix: [
                                        {
                                            block: 'b-experiment-params',
                                            elem: 'campaign-select',
                                            elemMods: { campaign: 'b' }
                                        },
                                        {
                                            block: 'b-experiment-params',
                                            elem: 'model-field',
                                            js: {
                                                name: 'secondaryCid',
                                                type: 'select'
                                            }
                                        },
                                    ],
                                    inputHint: iget2('b-experiment-params', 'nayti-po-nomeru-ili', 'Найти по номеру или названию'),
                                    emptyHint: iget2('b-experiment-params', 'net-kampaniy-sootvetstvuyushchih-filtru', 'Нет кампаний, соответствующих фильтру'),
                                    defaultText: u['b-campaigns-select'].EMPTY_TEXT,
                                    name: 'cid',
                                    campaigns: campaigns,
                                    disabledCampaigns: u['b-experiment-params'].getDisabledCampaigns(campaigns),
                                    addEmpty: true,
                                    selectNone: true
                                }
                            }
                        ]
                    },
                    {
                        elem: 'cell',
                        elemMods: { side: 'right' },
                        content: [
                            {
                                elem: 'item',
                                content: iget2('b-experiment-params', 'procent-auditorii', 'Процент аудитории') + ':'
                            },
                            {
                                elem: 'item',
                                elemMods: { type: 'percent-input' },
                                content: {
                                    block: 'input',
                                    mix: [
                                        {
                                            block: 'b-experiment-params',
                                            elem: 'percent-input',
                                            elemMods: { campaign: 'b' }
                                        },
                                        {
                                            block: 'b-experiment-params',
                                            elem: 'model-field',
                                            js: {
                                                name: 'secondaryPercent',
                                                type: 'input'
                                            }
                                        }
                                    ],
                                    content: { elem: 'control' },
                                    value: defaultPercent
                                }
                            },
                            {
                                elem: 'item',
                                elemMods: { type: 'percent-text' },
                                content: {
                                    elem: 'percent-text',
                                    elemMods: { campaign: 'b' },
                                    mix: {
                                        block: 'b-experiment-params',
                                        elem: 'model-field',
                                        js: {
                                            name: 'secondaryPercent',
                                            type: 'inline'
                                        }
                                    },
                                    content: defaultPercent
                                }
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'cell',
                        content: [
                            {
                                elem: 'item',
                                elemMods: { type: 'label' },
                                content: iget2('b-experiment-params', 'testovyy-period', 'Тестовый период') + ':'
                            },
                            {
                                elem: 'item',
                                content: [
                                    {
                                        block: 'b-date-range-picker',
                                        mix: { block: 'b-experiment-params', elem: 'calendar' },
                                        mods: { type: 'super' },
                                        id: 'date-range',
                                        minDate: minDate,
                                        maxDate: u.moment().add(range + 1, 'd').format(dateFormat),
                                        start: minDate,
                                        finish: u.moment().add(range, 'd').format(dateFormat),
                                        ranges: [
                                            { title: iget2('b-experiment-params', '7-dney', '7 дней'), start: 1, finish: 7 },
                                            { title: iget2('b-experiment-params', '14-dney', '14 дней'), start: 1, finish: 14 },
                                            { title: iget2('b-experiment-params', '30-dney', '30 дней'), start: 1, finish: 30 },
                                            { title: iget2('b-experiment-params', '90-dney', '90 дней'), start: 1, finish: 90 }
                                        ],
                                        dateFormat: dateFormat,
                                        viewFormat: 'DD MMM YYYY'
                                    },
                                    {
                                        elem: 'hint',
                                        content: u.pluralForms(iget2('b-experiment-params', 'maksimum-s-den-dnya', 'максимум {foo} {день|дня|дней}', {
                                            foo: range
                                        }), range)
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        elem: 'cell',
                        elemMods: { side: 'right' },
                        content: {
                            elem: 'item',
                            content: {
                                block: 'b-help-link',
                                mods: { type: 'modal' },
                                url: u.getHelpUrl('ab-test-instruction'),
                                text: iget2('b-experiment-params', 'kak-podobrat-parametry-ab', 'Как подобрать параметры AB-теста')
                            }
                        }
                    }
                ]
            },
            {
                elem: 'row',
                elemMods: { type: 'actions' },
                content: {
                    block: 'button',
                    mix: [{
                        block: 'b-experiment-params',
                        elem: 'submit'
                    }],
                    content: iget2('b-experiment-params', 'sozdat-eksperiment', 'Создать эксперимент')
                }
            }
        ];
    })
);
