BEM.DOM.decl({ block: 'b-experiment-params', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this._campaigns = this.params.campaigns || [];

            // blocks
            this._submit = this.findBlockOn('submit', 'button');

            this._selectA = this.findBlockOn(this.elem('campaign-select', 'campaign', 'a'), 'b-campaigns-select');
            this._selectB = this.findBlockOn(this.elem('campaign-select', 'campaign', 'b'), 'b-campaigns-select');

            this._inputA = this.findBlockOn(this.elem('percent-input', 'campaign', 'a'), 'input');
            this._inputB = this.findBlockOn(this.elem('percent-input', 'campaign', 'b'), 'input');

            this._elemPseudoA = this.elem('percent-text', 'campaign', 'a');
            this._elemPseudoB = this.elem('percent-text', 'campaign', 'b');

            this._calendar = this.findBlockOn('calendar', 'b-date-range-picker');

            // events
            this._subscribe = BEM.create('i-subscription-manager');

            this._subscribe.wrap(this.model)
                .on('primaryCid', 'change', this._updateSelect.bind(this, this._selectB))
                .on('secondaryCid', 'change', this._updateSelect.bind(this, this._selectA))

                .on('primaryPercent', 'change', this._updatePercent.bind(this, 'secondaryPercent'))
                .on('secondaryPercent', 'change', this._updatePercent.bind(this, 'primaryPercent'));

            this._elemPseudoA.click(this._togglePercentInput.bind(this, undefined, this._inputA));
            this._elemPseudoB.click(this._togglePercentInput.bind(this, 'active', this._inputB));

            this._subscribe.wrap(this._submit).on('click', this._submitData, this);
        }
    },

    /**
     * Отправляет данные на сервер
     * @private
     */
    _submitData: function() {
        var data = this.model.toJSON(),
            errors = this.model.validate().errors,
            range = this._calendar.getRange(),
            submit = this._submit,
            showError = function(message) {
                BEM.blocks['b-confirm'].alert(message);
                submit.delMod('disabled');
            };

        submit.setMod('disabled', 'yes');

        if (errors) {
            showError(errors.map(function(el) { return el.text }).join('<br>'));

            return;
        }

        BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            type: 'POST',
            cache: false,
            callbackCtx: this
        }).get({
            cmd: 'ajaxCreateExperiment',
            primary_cid: data.primaryCid,
            secondary_cid: data.secondaryCid,
            percent: data.primaryPercent,
            date_from: range.start, // todo@dima117: передавать данные через модель?
            date_to: range.finish,
            ulogin: u.consts('ulogin') // todo@dima117a deps?
        },
        function(res) {
            res.error ? showError(res.error) : location.reload();
        },
        function() {
            showError(iget2('b-experiment-params', 'oshibka-pri-sozdanii-eksperimenta', 'Ошибка при создании эксперимента. Попробуйте еще раз.'));
        });
    },

    /**
     * Переключает модификатор 'secondary', определяющий кампанию, для которой вводится процентная доля
     * @param {String} modValue - значение модификатора: 'active'/undefined
     * @param {BEM} input - поле ввода, в которое нужно поставить фокус
     * @private
     */
    _togglePercentInput: function(modValue, input) {
        this.setMod('secondary', modValue);
        input.setMod('focused', 'yes');
    },

    /**
     * Пересчитывает процентную долю кампании по введенной доле второй кампании
     * @param {String} field -поле в модели, которое нужно обновить
     * @param {Object} e - параметры события (изменение текста в поле ввода)
     * @param {Object} data - данные
     * @private
     */
    _updatePercent: function(field, e, data) {
        var value = data.value;

        value < 0 && (value = 0);
        value > 100 && (value = 100);

        this.model
        // если вводить длинное число, то мы попытаемся несколько раз присвоить 0 в другое поле,
        // повторные change-ы другого поля не будут происходить, и мы сможем ввести в текущее поле число больше 100
        // пункт 1 в комментарии https://st.yandex-team.ru/DIRECT-55132#1469612224000
            .set(e.target.name, value)
            .set(field, 100 - value);

    },

    /**
     * Обновляет набор заблокированных элементов списка кампаний
     * @param {BEM} select - список кампаний
     * @param {Object} e - параметры события (изменение выбранной кампании в другом списке)
     * @param {Object} data - данные
     * @private
     */
    _updateSelect: function(select, e, data) {
        select.setCampaigns(
            this.params.campaigns,
            {
                disabledIds: u['b-experiment-params'].getDisabledCampaigns(this._campaigns, data.value),
                addEmpty: true
            });
    },

    destruct: function() {
        this._subscribe.dispose();
        this.__base.apply(this, arguments);
    }
});
