u.register({
    'b-experiment-params': {

        /**
         * Формирует список id заблокированных кампаний
         * @param {Object} campaigns - список кампаний
         * @param {String} campaigns.cid - id кампании
         * @param {String} campaigns.experiment_id - id текущего эксперимента
         * @param {String} exludedId - id кампании, котрую нужно заблокировать дополнительно
         * @returns {String[]}
         */
        getDisabledCampaigns: function(campaigns, exludedId) {
            return campaigns.reduce(function(prev, el) {
                (el.experiment_id || el.cid == exludedId) && prev.push(el.cid);

                return prev;
            }, []);
        }
    }
});
