BEM.DOM.decl({ block: 'b-experiments-settings-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        js: function() {
            this._renderDnaComponent();
        }
    },

    _saveButton: null,

    _isChangedValue: null,

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(!!this._isChangedValue);

        return deferred.promise();
    },

    /**
     * Преобразует данные из стейта компонента в серверные
     * @param {Object} state
     * @return {{sections: Array, segments: Array}}
     * @private
     */
    _provideData: function(state) {
        var sections = [],
            segments = [],
            bids = [];

        Object.keys(state.data).forEach(function(sectionId) {
            var section = state.data[sectionId];

            if (section.selected) {
                sections.push(Number(sectionId));

                if (state.isTargetingActive) {
                    Object.keys(section.segments).forEach(function(segmentId) {
                        section.segments[segmentId].selected &&
                            segments.push(Number(segmentId));
                    })
                }

                Object.keys(section.segments).forEach(function(segmentId) {
                    var rate = section.segments[segmentId].rate;

                    if (rate) {
                        (!state.isTargetingActive ||
                            (state.isTargetingActive && section.segments[segmentId].selected)) &&
                                bids.push({
                                    section_id: Number(sectionId),
                                    segment_id: Number(segmentId),
                                    multiplier_pct: rate.value + 100
                                });
                    }
                });
            }

        });

        return {
            sections: sections,
            segments: segments,
            bids: {
                isEnabled: state.isRatesActive,
                abSegments: bids
            }
        }
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('save').is(e.block.domElem) && this._onSaveClick(e, data);
        this.elem('cancel').is(e.block.domElem) && this._onCancelClick(e, data);
    },

    /**
     * Обработчик клика по любой кнопке "Сохранить"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onSaveClick: function(e, data) {
        this._saveButton || (this._saveButton = e.block);

        this.trigger('save', this._provideData(this._currentValue));
    },

    /**
     * Возвращает инстанс кнопки "Сохранить"
     * @private
     */
    _getSaveButton: function() {
        return this._saveButton || (this._saveButton = this.findBlockOn('save', 'button'));
    },

    /**
     * Обработчик клика по любой кнопке "Отмена"
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onCancelClick: function(e, data) {
        this.trigger('cancel');
    },

    /**
     * Обработчик изменения в попапе
     * @param {Object} state
     * @param {Object} state.data
     * @param {Boolean} state.isTargetingActive
     * @private
     */
    _onSettingsChange: function(state) {
        this._isChangedValue = true;
        this._currentValue = state;
        this._getSaveButton().delMod('disabled');
    },

    /**
     * Render DNA component
     */
    _renderDnaComponent: function() {
        var dna = window.dna,
            selected = this.params.selected;

        dna.reactDOMRender(dna.reactCreateElement(
            dna.components.ExperimentsControl, {
                onChange: this._onSettingsChange.bind(this),
                sections: this.params.sections,
                checkedSections: selected.sections,
                checkedSegments: selected.segments,
                rates: {
                    isEnabled: selected.bids.isEnabled,
                    data: selected.bids.abSegments
                },
                view: 'classic'
            }, null), this.elem('settings')[0]);
    },

    destruct: function() {
        window.dna.reactDOMUnmount(this.elem('settings')[0]);
        BEM.DOM.destruct(this.domElem, true); // чистим внутренности

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
                this._onButtonClick(e, data);
            });

        return false;
    }

});
