block('b-experiments-settings')(

    js()(function() {

        return {
            sectionsByCounter: this.ctx.sectionsByCounter,
            counters: this.ctx.counters,
            selected: this.ctx.selected,
            dataModel: this.ctx.campDataModel,
            bidsMeta: this.ctx.bidsMeta
        }
    }),

    elem('switcher').replace()(function() {
        var ctx = this.ctx;

        return {
            block: 'button2',
            mix: {
                block: this.block,
                elem: 'switcher'
            },
            mods: {
                theme: 'normal',
                size: 's',
                view: 'classic',
                disabled: !(ctx.counters.length && ctx.sections.length) ? 'yes' : ''
            },
            text: iget2('b-experiments-settings', 'change-button-text', 'Изменить')
        };
    }),

    elem('preview-archive').content()(function() {
        var ctx = this.ctx,
            selected = ctx.selected,
            failedToFetchMetrika = u.consts('failedToFetchMetrika'),
            sections = failedToFetchMetrika ? [] : u['b-experiments-settings'].getSections(ctx.counters, ctx.sectionsByCounter),
            text = [];

        if (selected.sections.length) {
            selected.sections.forEach(function(id) {
                var section = (u._.find(sections, function(section) {
                    return +section.section_id === +id;
                }) || {});

                section.archive && text.push(section.section_name);
            });
            if (text.length > 1) {
                text = text.join(', ')
                text = iget2('b-experiments-settings','segment-archive', '{name} - в архиве.', {
                    name: text
                });
            }
            return text;
        }
    }),

    elem('preview').content()(function() {
        var ctx = this.ctx,
            selected = ctx.selected,
            counters = u['b-experiments-settings'].convertCounters(ctx.counters),
            failedToFetchMetrika = u.consts('failedToFetchMetrika'),
            sections = failedToFetchMetrika ? [] : u['b-experiments-settings'].getSections(ctx.counters, ctx.sectionsByCounter),
            text = [];

        if (counters.length) {
            if (sections.length) {
                if (selected.sections.length) {
                    selected.sections.forEach(function(id) {
                        var section = (u._.find(sections, function(section) {
                            return +section.section_id === +id;
                        }) || {});

                        section.archive || text.push(section.section_name);
                    });

                    text.length > 1 ? text = text.join(', ') : text;
                    if (selected.segments.length) {
                        text += '<br/>' + iget2('b-experiments-settings', 'segments-selected', 'Включено нацеливание по экспериментальным сегментам.')
                    }
                    if (selected.bids.isEnabled) {
                        text += '<br/>' + iget2('b-experiments-settings', 'segments-bids-enabled', 'Включены корректировки ставок.')
                    }
                } else {
                    text = iget2('b-experiments-settings', 'no-sections-selected', 'Нет активных экспериментов.')
                }
            } else {
                text = iget2('b-experiments-settings', 'no-sections-with-link', 'Нет активных экспериментов. Создайте эксперименты в {link}.', {
                    link: {
                        block: 'link',
                        target: 'blank',
                        mods: { theme: 'without-border' },
                        url: u.formatUrl(
                            {
                                protocol: 'https',
                                host: 'audience.yandex.' + u.consts('tld')
                            }), content: iget2('b-experiments-settings', 'audience', 'Аудиториях')
                    }
                });
            }
        } else {
            text = iget2('b-experiments-settings', 'no-counters', 'Нет активных экспериментов. Укажите счетчики метрики.')
        }

        return text;
    }),

    elem('warning').tag()('span'),

    content()(function() {
        var ctx = this.ctx,
            failedToFetchMetrika = u.consts('failedToFetchMetrika'),
            sections = failedToFetchMetrika ? [] : u['b-experiments-settings'].getSections(ctx.counters, ctx.sectionsByCounter);

        return [
            {
                elem: 'preview-wrapper',
                content: failedToFetchMetrika ?
                    {
                        elem: 'warning',
                        content: iget2('b-experiments-settings', 'experiments-unavailable', 'Эксперименты временно недоступны')
                    } :
                    [
                        {
                            elem: 'preview-archive',
                            sectionsByCounter: ctx.sectionsByCounter,
                            selected: ctx.selected,
                            counters: ctx.counters
                        },
                        {
                            elem: 'preview',
                            sectionsByCounter: ctx.sectionsByCounter,
                            counters: ctx.counters,
                            selected: ctx.selected
                        }
                    ]
            },
            {
                elem: 'switcher',
                counters: ctx.counters,
                sections: sections
            },
            {
                block: 'b-hidden',
                mix: { block: 'b-experiments-settings', elem: 'hidden-value-sections' },
                attrs: {
                    name: 'json_ab_sections_statistic',
                    value: JSON.stringify(ctx.selected.sections)
                }
            },
            {
                block: 'b-hidden',
                mix: { block: 'b-experiments-settings', elem: 'hidden-value-segments' },
                attrs: {
                    name: 'json_ab_segments_retargeting',
                    value: JSON.stringify(ctx.selected.segments)
                }
            },
            {
                block: 'b-hidden',
                mix: { block: 'b-experiments-settings', elem: 'hidden-value-bids' },
                attrs: {
                    name: 'json_ab_segment_multipliers',
                    value: JSON.stringify(
                        ctx.selected.bids.abSegments.length ?
                            {
                                is_enabled: ctx.selected.bids.isEnabled,
                                ab_segments: ctx.selected.bids.abSegments
                            } :
                            {}
                    )
                }
            }
        ]
    })
);
