BEM.DOM.decl({ block: 'b-experiments-settings' }, {

    onSetMod: {
        js: function() {
            this._selected = this.params.selected;
            this._counters = this.params.counters;
            this._model = this.params.dataModel ?
                BEM.MODEL.getOne(this.params.dataModel) :
                undefined;

            this._utils = u['b-experiments-settings'];

            this._calcUsedCounters();

            this._model.fix();
        }
    },

    /**
     * Обновляет установленные счетчики
     * @param {String} counters
     */
    updateCounters: function(counters) {
        var sectionsByCounter = this.params.sectionsByCounter,
            sectionsList = this._utils.getSections(counters, sectionsByCounter),
            availableSections = [],
            availableSegments = [],
            bidsSegments;

        sectionsList.forEach(function(section) {
            availableSections.push(section.section_id);
            section.segments.forEach(function(segment) {
                availableSegments.push(segment.segment_id);
            });
        });

        bidsSegments = this._selected.bids.abSegments.filter(function(segment) {
            return availableSegments.indexOf(segment.segment_id) !== -1
        });

        this._selected = {
            sections: this._selected.sections.filter(function(section) {
                return availableSections.indexOf(section.section_id) !== -1
            }),
            segments: this._selected.segments.filter(function(segment) {
                return availableSegments.indexOf(segment.segment_id) !== -1
            }),
            bids: {
                isEnabled: bidsSegments.length ? this._selected.bids.isEnabled : false,
                abSegments: bidsSegments
            }
        };

        this._counters = counters;

        this._onPopupSave(this._selected);

        this._toggleDisable(!(counters.length && sectionsList.length));

        this._updatePreview();
    },

    /**
     * Переключает состояния disabled у кнопки открытия попапа
     * @param {Boolean} isDisabled
     * @private
     */
    _toggleDisable: function(isDisabled) {
        this.blockInside('switcher', 'button2').toggleMod('disabled', 'yes', isDisabled);
    },

    /**
     * Высчитывает используемые счетчики в экспериментах
     * @private
     */
    _calcUsedCounters: function() {
        var checkedSections = this._selected.sections,
            sectionsByCounter = this.params.sectionsByCounter,
            usedCounters = {};

        Object.keys(sectionsByCounter).forEach(function(counterId) {
            sectionsByCounter[counterId].forEach(function(section) {
                if (checkedSections.indexOf(section.section_id) !== -1) {
                    usedCounters[counterId] || (usedCounters[counterId] = []);

                    usedCounters[counterId].push(section.section_id);
                }
            });
        });

        this._model.set('counters_in_experiments', usedCounters);
    },

    /**
     * Обработчик клика по любой кнопке внутри блока
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onButtonClick: function(e, data) {
        this.elem('switcher').is(e.block.domElem) && this._onSwitcherClick(e, data);
    },

    /**
     * Обработчик события save в попапе
     * @param {Object} selected
     * @param {Array<number>} selected.sections - выбранные эксперименты
     * @param {Array<number>} selected.segments - выбранные сегменты
     * @private
     */
    _onPopupSave: function(selected) {
        this._selected = {
            sections: selected.sections,
            segments: selected.segments,
            bids: {
                isEnabled: selected.bids.isEnabled,
                abSegments: selected.bids.abSegments
            }
        };

        this.elem('hidden-value-sections').val(JSON.stringify(selected.sections));
        this.elem('hidden-value-segments').val(JSON.stringify(selected.segments));
        this.elem('hidden-value-bids').val(JSON.stringify(
            selected.bids.abSegments.length ?
                {
                    is_enabled: selected.bids.isEnabled,
                    ab_segments: selected.bids.abSegments
                } :
                {}
        ));

        this._calcUsedCounters();

        this._updatePreview();
    },

    /**
     * Обновляет содержимое превью
     * @private
     */
    _updatePreview: function() {
        BEM.DOM.update(this.elem('preview-wrapper'), BEMHTML.apply({
            block: 'b-experiments-settings',
            elem: 'preview',
            sectionsByCounter: this.params.sectionsByCounter,
            selected: this._selected,
            counters: this._counters
        }));
    },

    /**
     * Обработчик нажатия на кнопку открытия попапа
     * @private
     */
    _onSwitcherClick: function() {
        var popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $),
            sectionsByCounter = this.params.sectionsByCounter,
            counters = this._counters,
            subMan = BEM.create('i-subscription-manager'),
            experimentsPopup = popupDecorator
                .setPopupContent({
                    block: 'b-experiments-settings-popup',
                    sections: this._utils.filterExtraSections(
                        this._utils.getSections(counters, sectionsByCounter),
                        this._selected.sections
                    ),
                    selected: this._selected
                });

        subMan
            .on(experimentsPopup, 'save', function(e, data) {
                this._onPopupSave(data);
                popupDecorator.hide({ force: true });
            }, this)
            .on(experimentsPopup, 'cancel', function() {
                popupDecorator.hide({ force: true });
            }, this)
            .on(popupDecorator, 'close-blocked', function(e) {
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-experiments-settings', 'close-popup-message', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: popupDecorator.getPopup(),
                    onYes: function() {
                        popupDecorator.hide({ force: true });
                    }
                });
            }, this)
            .on(popupDecorator, 'close', function() {
                subMan.dispose();
                subMan.destruct();

                popupDecorator.destruct();
            }, this);

        popupDecorator.show();
    }
}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button2', function(e, data) {
            this._onButtonClick(e, data);
        });

        return false;
    }

});
