u.register({
    'b-experiments-settings': {

        /**
         * Достает секции из хеша счетчиков
         * @param {String} counters
         * @param {Object} sectionsByCounter
         * @return {*|Array}
         */
        getSections: function(counters, sectionsByCounter) {

            var countersArr = this.convertCounters(counters);

            return countersArr.reduce(function(result, counter) {
                var counterSections = sectionsByCounter[counter],
                    filteredSections = [];

                if (counterSections) {
                    filteredSections = counterSections.filter(function(section) {
                        return !result.some(function(addSection) {
                            return addSection.section_id === section.section_id;
                        });
                    });

                    result = result.concat(filteredSections);
                }

                return result;
            }, [])
        },

        filterExtraSections: function(sections, selectedSections) {

            return sections.filter(function(section) {
                return !section.archive || section.archive && selectedSections.includes(section.section_id);
            });
        },

        convertCounters: function(counters) {
            return counters.length ?
                counters.split(',').map(function(counter) {
                    return Number(counter)
                }) : [];
        }

    }
});
