/**
 * @param {String} [ctx.title] заколовок блока
 * @param {String} [ctx.placeholder] placeholder для поля ввода ссылки
 **/
block('b-external-file-uploader').mod('type', 'modal')(

    content()(function() {

        return [
            {
                elem: 'body',
                mix: { block: 'b-modal-popup-decorator', elem: 'body' },
                content: [
                    this.ctx.title && {
                        elem: 'title',
                        content: this.ctx.title
                    },
                    {
                        elem: 'input',
                        placeholder: this.ctx.placeholder,
                        autoFocus: true
                    }
                ]
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action' },
                        mix: {
                            block: 'b-external-file-uploader',
                            elem: 'submit'
                        },
                        content: iget2('b-external-file-uploader', 'zagruzit', 'Загрузить')
                    },
                    {
                        block: 'button',
                        mix: {
                            block: 'b-external-file-uploader',
                            elem: 'cancel'
                        },
                        content: iget2('b-external-file-uploader', 'otmena', 'Отмена')
                    }
                ]
            },
            {
                elem: 'paranja'
            }
        ];
    }),

    elem('title').tag()('h3'),

    elem('paranja').content()({
        block: 'spin',
        mix: {
            block: 'b-external-file-uploader',
            elem: 'spin'
        },
        mods: {
            theme: 'gray-16'
        }
    })
);
