BEM.DOM.decl({
    block: 'b-external-file-uploader',
    modName: 'type',
    modVal: 'modal',
    implements: 'i-modal-popup-inner-block-interface'
}, {
    onSetMod: {
        js: function() {
            this.__base();

            this._cancelButton = this.findBlockOn('cancel', 'button');
            this._submitButton = this.findBlockOn('submit', 'button');

            this._cancelButton.on('click', function() {
                this.trigger('cancel');
            }, this);

            this._refreshButtonState();

            this._submitButton.on('click', this.save, this);
        },

        loading: function(modName, modVal) {
            this._spin = this._spin || this.findBlockOn('spin', 'spin');

            this.setMod(this.elem('paranja'), 'visible', modVal);
            this._spin.setMod('progress', modVal);
        }
    },

    /**
     * Показывает блок в модальном окне
     */
    show: function() {
        this._modal && this._modal.show();
    },

    /**
     * Закрывает модальное окно с блоком
     */
    hide: function() {
        this._modal && this._modal.hide();
    },

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        // не закрывается, если установлен модификатор загрузки
        deferred.resolve(this.getMod('loading') === 'yes');

        return deferred;
    },

    /**
     * Деструктор
     * @returns {*}
     */
    destruct: function() {
        this._cancelButton.un('click');
        this._submitButton.un('click');
        this._modal && this._modal.un('close', this.resetForm, this);

        return this.__base.apply(this, arguments);
    },

    /**
     * Изменение значения в инпуте
     * @private
     */
    _onInputChange: function() {
        this._refreshButtonState();
        this._clearErrors();
    },

    /**
     * Устанавливает и инициализирует модальное окно для блока
     * @param {BEM.DOM<b-modal-popup-decorator>} modal блок-декоратор модального попапа
     * @private
     */
    _setModal: function(modal) {
        this._modal = modal;

        this.on('cancel', this.hide, this);

        this._modal.on('close', this.resetForm, this);
    },

    /**
     * Определяет доступность использования кнопки Загрузки ссылки
     * @private
     */
    _refreshButtonState: function() {
        this._submitButton.setMod('disabled', this._inputControl.val().trim() === '' ? 'yes' : '' );
    }
}, {
    /**
     * Создаёт блок загрузки файла по ссылке в модальном окне
     * @param {Object} [ctx] контекст блока
     * @param {String} [ctx.title] заголовок блока
     * @param {String} [ctx.placeholder] placeholder для поля ввода ссылки
     * @returns {BEM.DOM<b-external-file-uploader>}
     */
    create: function(ctx) {
        var modal,
            uploader,
            blockJson = {
                block: 'b-external-file-uploader',
                mods: {
                    type: 'modal'
                }
            };

        modal = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $);
        u._.extend(blockJson, ctx || {});
        uploader = modal.setPopupContent(blockJson);
        uploader._setModal(modal);

        return uploader;
    }
});
