BEM.DOM.decl('b-favorites-checkbox', {

    onSetMod: {
        js: function() {
            this._initEvents();
        }
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.__base();
    },

    /**
     * Подписка на события (click, change) блока checkbox
     * Проксирование событий внутреннего блока select вверх
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');
        this._subscriptionManager
            .wrap(this.findBlockInside('checkbox'))
            .on('click', function() { this.trigger('click'); }, this)
            .on('change', function(e) {
                this.trigger('change', { isChecked: e.block.isChecked() });
            }, this);
    }
}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'checkbox');
    }
});
