BEM.DOM.decl('b-feature-marker', {
    onSetMod: {
        js: {
            inited: function() {
                var params = this.params,
                    featureId = params.featureId,
                    dynamic = params.dynamic,
                    text = params.text,
                    helpUrl = params.helpUrl;

                this.cookieName = 'feature-' + featureId;

                if (!this.__self.shown[featureId] && $.cookie(this.cookieName) !== '1') {

                    this.__self.shown[featureId] = true;

                    this.popup = this._createPopup(text, helpUrl)
                        .setAnchor(this.domElem);

                    this.popupBody = this.popup.findBlockInside('b-feature-marker-popup');

                    this.subscriptionManager = BEM.create('i-subscription-manager')
                        .on(this.popupBody, 'hide', this._hidePopup, this);

                    if (!dynamic) {
                        this.show();
                    }
                }
            }
        }
    },

    show: function() {
        this.popup && this.popup.setMod('visible', 'yes');
    },

    _createPopup: function(text, helpUrl) {
        var params = this.params,
            direction = params.direction || 'bottom-left',
            mainOffset = params.mainOffset || 7,
            secondaryOffset = params.secondaryOffset || 0,
            zIndexGroupLevel = params.zIndexGroupLevel === undefined ? 35000 : params.zIndexGroupLevel;

        return $(BEMHTML.apply({
            block: 'popup2',
            zIndexGroupLevel: zIndexGroupLevel,
            mix: { block: 'b-feature-marker', elem: 'popup' },
            mods: { target: 'anchor', theme: 'clear' },
            directions: [direction],
            mainOffset: mainOffset,
            secondaryOffset: secondaryOffset,
            content: {
                block: 'b-feature-marker-popup',
                mods: {
                    'tail-to-the-bottom-right': direction.indexOf('bottom-right') !== -1 ? 'yes' : '',
                    'tail-to-the-right-center': direction.indexOf('right-center') !== -1 ? 'yes' : ''
                },
                text: text,
                helpUrl: helpUrl
            }
        })).bem('popup2');
    },

    _hidePopup: function() {
        $.cookie(this.cookieName, 1, { expires: 3650 });
        this.subscriptionManager.dispose();
        this.popup.destruct();
    }
}, {
    shown: {}
});
