BEM.DOM.decl('b-feed-category-chooser', {
    onSetMod: {
        js: function() {
            this._index = this._createIndex(this.params.items || []);

            this.tree = this.findBlockInside('tree', 'b-feed-category-tree');
            this.list = this.findBlockInside('list', 'b-feed-category-list');
            this.treeChooser = this.tree.getChooser();

            this._triggerChangeDebounce = $.debounce(this.triggerChange, 50, this);
            this._repaintListDebounce = $.debounce(this.repaintList, 50, this);

            this.tree.on('change', this._onTreeChange, this);
            this.treeChooser.on('init-finish', this._onTreeChooserInitFinish, this);

            this.list.on('remove', function(e, data) {
                this.treeChooser.uncheck(data.name);
            }, this);
        }
    },

    /**
     * Обрабатывает change блока b-feed-category-tree
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onTreeChange: function(e, data) {
        if (data.fromGroupCheckbox) {
            // в случае «Выбрать все» и пустом инпуте, нет необходимости вызывать toggleParent и toggleChildren
            // сокращаем вызов т.к. очень долгие операции
            if (!data.searchValue) {
                this._repaintListDebounce();
                this._triggerChangeDebounce();

                return;
            }

            this._toggleDependencies(data.changedItems);
        } else {
            this._toggleDependencies([data]);
        }

        this._repaintListDebounce();
        this._triggerChangeDebounce();
    },

    /**
     * Пересчитывает состояние selected категорий после того как b-chooser закончит построение виртуальной структуры
     * @private
     */
    _onTreeChooserInitFinish: function() {
        this.treeChooser
            .getSelected()
            .forEach(function(item) {
                var index = this._index[item.name];

                if (!(index.childrens || []).length) {
                    this._toggleParent(index.parentId);
                }
            }, this);

        this._repaintListDebounce();
    },

    /**
     * Меняет состояние selected всех зависимых категорий
     * @param {Array} items - список измененных элементов
     * @returns {BEM}
     * @private
     */
    _toggleDependencies: function(items) {
        items.forEach(function(item) {
            if (!item.extraParams.skipChange) {
                this._toggleChildren(item.name, item.selected);

                if (this._index[item.name].parentId) {
                    this._toggleParent(this._index[item.name].parentId);
                }
            }
        }, this);

        return this;
    },

    /**
     * Перерисовывает правый список b-feed-category-list
     * за счет структуры b-feed-category-tree
     * @returns {BEM}
     */
    repaintList: function() {
        var virtualTree = this.treeChooser.getVirtualItems(),
            disabled = [],
            items = [];

        virtualTree.forEach(function(item) {
            if (item.elemMods.selected === 'yes') {
                item.elemMods.disabled === 'yes' ?
                    disabled.push(u._.clone(item, true)) :
                    items.push(u._.clone(item, true));
            }
        }, this);

        this.list.repaintItems(disabled.concat(items));

        return this;
    },

    /**
     * Триггерит событие change
     * @returns {BEM}
     */
    triggerChange: function() {
        return this.trigger('change');
    },

    /**
     * Меняет состояние selected подкатегорий
     * @param {String} name - идентификатор категории
     * @param {Boolean} selected - состояние selected родительской категории
     * @returns {BEM}
     * @private
     */
    _toggleChildren: function(name, selected) {
        this._index[name].children.forEach(function(id) {
            var itemParams = this.treeChooser.getItem(id);

            if (selected) {
                // нельзя выбирать задизейбленные категории
                if (!itemParams.disabled) {
                    this.treeChooser
                        .check(id, { skipChange: true });
                }
            } else {
                this.treeChooser
                    .uncheck(id, { skipChange: true });
            }

            this._toggleChildren(id, selected);
        }, this);

        return this;
    },

    /**
     * Меняет состояние selected родительских категорий
     * @param {String} parentId - идентификатор категории
     * @returns {BEM}
     * @private
     */
    _toggleParent: function(parentId) {
        var parent = this._index[parentId],
            indeterminate = 0,
            checked = 0;

        parent.children.forEach(function(id) {
            var itemParams = this.treeChooser.getItem(id);

            itemParams.indeterminate && indeterminate++;
            itemParams.selected && checked++;
        }, this);

        if (!indeterminate && parent.children.length === checked) {
            this.treeChooser
                .check(parentId, { skipChange: true });
        } else if (checked === 0) {
            this.treeChooser
                .uncheck(parentId, { skipChange: true });
        } else {
            this.treeChooser
                .setIndeterminate(parentId, { skipChange: true });
        }

        parent.parentId && this._toggleParent(parent.parentId);

        return this;
    },

    /**
     * Возвращает выбранные категории
     * @returns {Array} массив из id
     */
    getValue: function() {
        return u._.pluck(this.treeChooser.getSelected(), 'name').map(Number);
    },

    /**
     * Возвращает объект, где ключ это id категории
     * id подкатегории содержатся в массиве children
     * id родительской (если есть) в parentId
     * @param {Array} data
     * @returns {Object}
     * @private
     */
    _createIndex: function(data) {
        return data.reduce(function(index, item) {
            var id = item.category_id,
                parentId = item.parent_category_id;

            (index[parentId] || (index[parentId] = { children: [] })).children.push(id);
            (index[id] || (index[id] = { children: [] })).parentId = parentId;

            return index;
        }, {});
    }

}, {

});
