BEM.DOM.decl('b-feed-category-list', {
    onSetMod: {
        js: function() {
            this._chooser = this.findBlockOn('b-chooser');
        }
    },

    /**
     * Перерисовывает список
     * Неочевидно и некрасиво переопределяем структуру элементов из b-feed-category-tree
     * @param {Object[]} items
     * @param {'b-chooser'} items.block
     * @param {'item'} items.elem
     * @param {Object} items.elemMods
     * @param {Object} items.mix
     * @param {Object} items.js
     * @param {String} items.name
     * @param {Number} items.height
     * @param {*} [items.content]
     * @param {Object} [items._searchData]
     */
    repaintItems: function(items) {
        items = items.map(function(item) {
            item.content.push({
                block: 'icon',
                mods: { 'size-16': 'trash' },
                mix: {
                    block: 'b-feed-category-list',
                    elem: 'remove',
                    js: { name: item.name }
                }
            });

            return u._.extend(item, {
                elemMods: {
                    disabled: item.elemMods.disabled ? 'yes' : '',
                    click: 'ignore',
                    visibility: ''
                },
                mix: {
                    block: 'b-feed-category-list',
                    elem: 'item',
                    elemMods: { 'top-level': item.js.path ? '' : 'yes' }
                },
                _searchData: undefined
            });
        }, this);

        this._chooser
            .setVirtualItems(items)
            .updateAll();
    }

}, {
    live: function() {
        this.liveBindTo('remove', 'click', function(e) {
            this.trigger('remove', this.elemParams(e.data.domElem));
        });
    }
});
