u.register({
    'b-feed-category-tree': {

        /**
         * Высота элемента на отрисованной странице
         */
        itemHeight: 40,

        /**
         * Высота элемента(вместе с ссылкой родительской категории) на отрисованной странице
         */
        itemHeightWithParent: 58,

        /**
         * @param {Object[]} list
         * @param {Object} selected объект из выбранных пунктов
         * @returns {Object[]}
         */
        listToBEMJSON: function(list, selected) {
            var disabledIndex = 0,
                notDisabledIndex = 0,
                groupedItems = u._.groupBy(list, function(item) {
                    if (!item.parent_category_id || item.parent_category_id === '0') {
                        return 'roots';
                    }

                    return item.parent_category_id;
                }),
                reduceTree = function(memo, item) {
                    memo.push(item);

                    groupedItems[item.category_id] && groupedItems[item.category_id].forEach(function(sub) {
                        reduceTree(memo, sub);
                    });

                    return memo;
                },
                makePath = function(pathArray) {
                    // пустое пространство перед стрелкой - символ неразрыного пробела
                    // charCode = 160 (обычный пробел = 32)
                    var arrow = ' →',
                        names = pathArray.map(function(index) {
                            return list[index].name;
                        });

                    return {
                        raw: names.join('→'),
                        trimmed: u.hellipCut(names.join(arrow + ' '), 30, '...' + arrow)
                    };
                };

            return groupedItems.roots ?
                groupedItems.roots
                    .sort(function(a, b) {
                        return a.name.localeCompare(b.name);
                    })
                    .reduce(function(tree, item) {
                        return reduceTree(tree, item);
                    }, [])
                    .map(function(item) {
                        var pathData = makePath(item.path),
                            path = pathData.trimmed,
                            hasParent = !!item.parent_category_id && !!item.path.length;

                        return {
                            block: 'b-chooser',
                            elem: 'item',
                            elemMods: {
                                disabled: item.is_deleted ? 'yes' : '',
                                visibility: item.is_deleted ? 'hidden' : '',
                                selected: selected[item.category_id] ? 'yes' : ''
                            },
                            mix: {
                                block: 'b-feed-category-tree',
                                elem: 'item',
                                elemMods: !hasParent && { 'top-level': 'yes' }
                            },
                            js: {
                                path: hasParent && path,
                                name: item.category_id,
                                title: item.name,
                                position: item.is_deleted ? disabledIndex++ : notDisabledIndex++,
                                search: {
                                    path: hasParent && path,
                                    title: item.name,
                                    description: item.category_id
                                }
                            },
                            name: item.category_id,
                            height: hasParent ? this.itemHeightWithParent : this.itemHeight, // для блока с модификатором b-chooser_virtual_yes
                            content: [
                                hasParent && {
                                    elem: 'path',
                                    content: path,
                                    attrs: pathData.raw.length > 30 ? { title: pathData.raw } : {}
                                },
                                {
                                    elem: 'title',
                                    content: {
                                        elem: 'title-text',
                                        content: item.name
                                    }
                                },
                                { elem: 'description', content: item.category_id }
                            ]
                        }
                    }, this) :
                    [];
        }

    }
});
