block('b-feed-edit-popup').elem('business-type-form').content()(function() {
    var businessType = this.ctx.feed.business_type || u.feedData.defaultBusinessType;

    return {
        block: 'b-layout-table',
        content: [{
            elem: 'row',
            content: [
                {
                    elem: 'cell',
                    mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                    content: [
                        iget2('b-feed-edit-popup', 'tip-biznesa', 'Тип бизнеса'),
                        { block: 'b-feed-edit-popup', elem: 'required-mark' }
                    ]
                },
                {
                    elem: 'cell',
                    mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                    content: {
                        block: 'select',
                        mix: {
                            block: 'b-feed-edit-popup',
                            elem: 'model-field',
                            js: [
                                { type: 'select', name: 'business_type' },
                                {
                                    type: 'mod',
                                    name: 'locked',
                                    block: 'select',
                                    modName: 'disabled'
                                }
                            ]
                        },
                        value: businessType,
                        content: [
                            {
                                block: 'button',
                                content: u.getFeedBusinessTypeText(businessType)
                            },
                            {
                                elem: 'control',
                                content: u._.filter(u.feedData.businessType, function(feed) {
                                    // Если в списке доступных фидов есть заблокированные - отфильтровываем их
                                    return !~(this.ctx.disabledFeeds || []).indexOf(feed);
                                }, this).map(function(val) {
                                    return {
                                        elem: 'option',
                                        attrs: { value: val },
                                        content: u.getFeedBusinessTypeText(val)
                                    };
                                })
                            }
                        ]
                    }
                }
            ]
        }]
    };
});
