block('b-feed-edit-popup').elem('file-form')(

    mix()({
        block: 'b-feed-edit-popup',
        elem: 'model-field',
        js: {
            type: 'mod',
            name: 'locked',
            block: 'b-feed-edit-popup',
            elem: 'file-form',
            modName: 'disabled'
        }
    }),

    elemMod('source', 'url').content()(function() {
        return {
            block: 'b-layout-table',
            content: [
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            content: [
                                iget2('b-feed-edit-popup', 'url-fida', 'URL фида'),
                                { block: 'b-feed-edit-popup', elem: 'required-mark' }
                            ]
                        },
                        {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            content: {
                                block: 'input',
                                mix: [
                                    { block: 'b-feed-edit-popup', elem: 'url' },
                                    {
                                        block: 'b-feed-edit-popup',
                                        elem: 'model-field',
                                        js: [
                                            { type: 'input', name: 'url' },
                                            {
                                                type: 'mod',
                                                name: 'locked',
                                                block: 'input',
                                                modName: 'disabled'
                                            }
                                        ]
                                    }
                                ],
                                value: this.ctx.feed.url || '',
                                content: {
                                    elem: 'control',
                                    attrs: { maxlength: u.consts('MAX_URL_LENGTH') }
                                }
                            }
                        }
                    ]
                },
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            content: {
                                block: 'checkbox',
                                mods: { checked: this.ctx.feed.authRequired ? 'yes' : '' },
                                mix: {
                                    block: 'b-feed-edit-popup',
                                    elem: 'model-field',
                                    js: [
                                        { type: 'checkbox', name: 'authRequired' },
                                        {
                                            type: 'mod',
                                            name: 'locked',
                                            block: 'checkbox',
                                            modName: 'disabled'
                                        }
                                    ]
                                },
                                text: iget2('b-feed-edit-popup', 'trebuetsya-avtorizaciya', 'Требуется авторизация')
                            }
                        },
                        {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            content: [
                                {
                                    hint: iget2('b-feed-edit-popup', 'login', 'логин'),
                                    name: 'login',
                                    value: this.ctx.feed.login || ''
                                },
                                {
                                    hint: iget2('b-feed-edit-popup', 'parol', 'пароль'),
                                    name: 'password'
                                }
                            ].map(function(input) {

                                return {
                                    block: 'input',
                                    mods: {
                                        disabled: this.ctx.feed.login ? '' : 'yes',
                                        type: input.name === 'password' ? 'password' : ''
                                    },
                                    mix: [
                                        { block: 'b-feed-edit-popup', elem: 'auth-input' },
                                        {
                                            block: 'b-feed-edit-popup',
                                            elem: 'model-field',
                                            js: [
                                                { type: 'formatted-input', name: input.name },
                                                {
                                                    type: 'mod',
                                                    name: 'lockedAuth',
                                                    block: 'input',
                                                    modName: 'disabled'
                                                }
                                            ]
                                        }
                                    ],
                                    value: input.value,
                                    placeholder: input.hint,
                                    content: [
                                        { elem: 'control' }
                                    ]
                                };
                            }, this)
                        }
                    ]
                },
                {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            attrs: { colspan: 2 },
                            content: {
                                block: 'checkbox',
                                mods: { checked: this.ctx.feed.removeUTM ? 'yes' : '' },
                                mix: {
                                    block: 'b-feed-edit-popup',
                                    elem: 'model-field',
                                    js: [
                                        { type: 'checkbox', name: 'removeUTM' },
                                        {
                                            type: 'mod',
                                            name: 'locked',
                                            block: 'checkbox',
                                            modName: 'disabled'
                                        }
                                    ]
                                },
                                text: iget2('b-feed-edit-popup', 'avtomaticheski-udalyat-utm-metki', 'Автоматически удалять UTM-метки')
                            }
                        }
                    ]
                }
            ]
        };
    }),

    elemMod('source', 'file').content()(function() {
        return {
            block: 'b-layout-table',
            content: [
                this.ctx.feed.fileName && {
                    elem: 'row',
                    content: [
                        {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            content: iget2('b-feed-edit-popup', 'tekushchiy-fayl', 'Текущий файл')
                        },
                        {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            content: {
                                block: 'b-feed-edit-popup',
                                elem: 'current-file',
                                content: u.escapeHTML(this.ctx.feed.fileName)
                            }
                        }
                    ]
                },
                {
                    elem: 'row',
                    content: [
                        this.ctx.feed.fileName && {
                            elem: 'cell',
                            mix: { block: 'b-feed-edit-popup', elem: 'cell' },
                            content: iget2('b-feed-edit-popup', 'novyy-fayl', 'Новый файл')
                        },
                        {
                            elem: 'cell',
                            mix: {
                                block: 'b-feed-edit-popup',
                                elem: 'cell',
                                elemMods: this.ctx.feed.fileName && {
                                    'fixed-width-attach-cell': 'yes'
                                }
                            },
                            content: [
                                {
                                    block: 'attach',
                                    // ограничение на количество символов прикрепляемого файла
                                    // зависит от свободного пространства в шаблоне
                                    mods: { size: 's', cut: 'yes', theme: 'normal' },
                                    text: iget2('b-feed-edit-popup', 'vybrat-fayl', 'Выбрать файл'),
                                    holder: true,
                                    mix: { block: 'b-feed-edit-popup', elem: 'attach' },
                                    name: 'feed_file',
                                    limit: this.ctx.feed.fileName ? 18 : 33
                                }
                            ]
                        }
                    ]
                }
            ]
        };
    })
);
