block('b-feed-edit-popup').elem('form')(

    mix()({
        block: 'b-feed-edit-popup',
        elem: 'model-field',
        js: {
            type: 'mod',
            name: 'source',
            block: 'b-feed-edit-popup',
            elem: 'form',
            modName: 'source'
        }
    }),

    def()(function() {
        return applyNext({
            'ctx.tailElems': [
                {
                    elem: 'errors',
                    elemMods: { common: 'yes' }
                },
                {
                    elem: 'errors',
                    elemMods: { type: 'file' }
                },
                {
                    elem: 'errors',
                    elemMods: { type: 'url' }
                }
            ]
        });
    }),

    content()(function() {
        return [
            {
                elem: 'base-form',
                feed: this.ctx.feed
            },
            {
                elem: 'file-form',
                elemMods: {
                    'auth-required': this.ctx.feed.source === 'url' && this.ctx.feed.login ? 'yes' : '',
                    source: u.beminize(this.ctx.feed.source)
                },
                feed: this.ctx.feed
            },
            this.ctx.tailElems
        ];
    }),

    elemMod('source-choose', 'yes').content()(function() {
        return [
            {
                elem: 'base-form',
                feed: this.ctx.feed
            },
            {
                elem: 'business-type-form',
                disabledFeeds: this.ctx.disabledFeeds,
                feed: this.ctx.feed
            },
            {
                elem: 'file-source',
                feed: this.ctx.feed
            },
            ['url', 'file'].map(function(source) {
                return {
                    elem: 'file-form',
                    elemMods: {
                        'auth-required': this.ctx.feed.source === 'url' && this.ctx.feed.login ? 'yes' : '',
                        source: source
                    },
                    feed: this.ctx.feed
                };
            }, this),
            this.ctx.tailElems
        ];
    })
);
