block('b-feed-edit-popup')(

    match(function() { return !this.ctx.feed })
        .def()(function() {
            return applyNext({ 'ctx.feed': { source: 'url' } });
        }),

    js()(function() {
        return {
            modelData: {
                feedId: this.ctx.feed.feedId,
                source: this.ctx.feed.source
            }
        };
    }),

    tag()('form'),

    attrs()({
        autocomplete: 'off'
    }),

    mix()({
        block: 'i-form',
        mods: { submit: 'bem-event' }
    }),

    content()(function() {
        return [
            {
                elem: 'title',
                feed: this.ctx.feed
            },
            {
                elem: 'form',
                // для созданных фидов форма ввода файла не может более меняться
                elemMods: {
                    source: this.ctx.feed.source,
                    'source-choose': this.ctx.feed.feedId ? '' : 'yes'
                },
                disabledFeeds: this.ctx.disabledFeeds,
                feed: this.ctx.feed
            },
            { elem: 'buttons' }
        ];
    })
);
