BEM.DOM.decl({ block: 'b-feed-edit-popup', baseBlock: 'i-glue' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this.model.init();

            u.graspSelf.call(this, {
                _form: 'i-form on',
                _urlInput: '? input on url',
                _attach: '? attach on attach'
            });

            this._subscriptions = BEM.create('i-subscription-manager');

            this._initEvents();
            this._initModelEvents();

            // инициализация всех доступных форм для загрузки фида
            this.setMod(this.elem('file-form'), 'init', 'yes');

            this.model.validate();
        }

    },

    onElemSetMod: {

        'file-form': {

            init: function(elem) {
                // события формы для загрузки файлов
                if (this.hasMod(elem, 'source', 'file')) {
                    this._attach.on('change reset', function(e) {
                        var fileName = e.block.val();

                        // возвращаем значение из DM для ненового фида, если сбросили прикрепленный файл
                        fileName || !this.model.isNew() && (fileName = this.model.getFieldFromDM('fileName'));

                        this.model.set('fileName', fileName);
                    }, this);
                }

                // события формы с полем ввода ссылки на файл
                if (this.hasMod(elem, 'source', 'url')) {
                    // при потере фокуса нужно инициировать валидацию для подсветки поля ввода
                    this._urlInput.on('blur', function() {
                        this.model.validate('url');
                    }, this);
                }
            },

            disabled: function(elem, modName, modVal) {
                // если блокируем форму с attach блоком, то выключаем attach
                // при показе включаем обратно
                if (this.hasMod(elem, 'source', 'file')) {
                    this.afterCurrentEvent(function() {
                        this.domElem && this._attach.toggleMod('disabled', 'yes', modVal == 'yes');
                    }, this);
                }
            }

        }

    },

    /**
     * Удаляет блок
     * @param {Boolean} [keepDOM=false] флаг о том, что не надо удалять DOM элемент при разрушении блока
     * @override для удаления попапов
     */
    destruct: function(keepDOM) {
        this._subscriptions.dispose();
        this._subscriptions.destruct();

        BEM.DOM.destruct(this.domElem, true);

        this.__base(keepDOM);
    },

    /**
     * Инициализирует события блока
     * @private
     */
    _initEvents: function() {
        this._subscriptions.wrap(this._form)
            .on('submit', this._save, this)
            .on('reset', function() {
                this.trigger('cancel');
            }, this);
    },

    /**
     * Инициализирует события модели
     * @private
     */
    _initModelEvents: function() {
        this._subscriptions.wrap(this.model)
            .on('locked', 'change', function(e, data) {
                data.value ?
                    // при блокировке модели чистим общие ошибки
                    this._renderErrors('') :
                    // после - перевалидируем модель
                    this.model.validate();
            }, this)
            .on('source name url login password fileName authRequired', 'change', function() {
                // общая валидация при изменении полей
                this.model.validate();
            }, this)
            .on('url fileName', 'change', function(e, data) {
                // инициализация подсветки ошибок при вводе url или прикрепления файла
                this.model.validate(data.field);
            }, this)
            .on('validated', function(e, data) {
                var isValid = !!data.valid,
                    isValidField,
                    errors = {};

                if (!data.field) {
                    this.model.set('isValid', isValid);
                } else if (data.field == 'fileName') {
                    // подсветка ошибок про файл
                    isValidField = this.model.isEmpty('fileName') || isValid;

                    errors.file = isValidField ? '' : data.errors.map(function(error) {
                        return error.text;
                    });
                } else if (data.field == 'url') {
                    // не нужна подсветка, если не указан URL или он валиден
                    isValidField = this.model.isEmpty('url') || isValid ||
                        // не подсвечивать ошибки при неправильном вводе (инпут в фокусе и ещё не выставлен мод-р ошибки)
                        !this._urlInput.hasMod('error', 'yes') && this._urlInput.hasMod('focused', 'yes');

                    // подсветка ошибок про url
                    this._urlInput.toggleMod('error', 'yes', !isValidField);

                    errors.url = isValidField ? '' : iget2('b-feed-edit-popup', 'ukazhite-url-k-faylu', 'Укажите URL к файлу фида');
                }

                u._.forOwn(errors, function(errorsText, key) {
                    this._renderErrors(errorsText, key);
                }, this);
            }, this);
    },

    /**
     * Отправляет POST запрос для сохранения фида
     * @private
     */
    _save: function() {
        var dna = window.dna;

        if (!dna) {
            this._afterSave({
                success: false
            })

            throw new Error('An error has occurred in loading DNA dependencies');
        }

        var data = u._.extend({}, this.model.provideData()),
            apiManager = dna.utils.getRestApiManager(),
            request = null;

        // для отправки файла цепляем к отправляемым данным контрол загрузки файла
        if (data.source === 'file') {
            data.file = this._attach.findElem('control');
        }

        this.model.set('locked', true);

        if (data.feed_id) {
            request = apiManager.updateFeedForOldInterface(u.consts('ulogin'), {
                feedId: data.feed_id,
                name: data.name,
                source: data.source,
                file: data.file && data.file[0].files[0],
                url: data.url,
                login: data.login,
                password: data.password,
                isRemoveUtm: data.is_remove_utm
            });
        } else {
            request = apiManager.addFeedForOldInterface(u.consts('ulogin'), {
                name: data.name,
                businessType: data.business_type,
                source: data.source,
                file: data.file && data.file[0].files[0],
                url: data.url,
                login: data.login,
                password: data.password,
                isRemoveUtm: data.is_remove_utm
            });
        }

        request.then(function(res) {
            this._afterSave(res);
        }.bind(this))
            .catch(function() {
                this._afterSave({
                    success: false
                })
            }.bind(this));
    },

    /**
     * Обрабатывает ответ при сохранении фида
     * @param {Object} response
     * @private
     */
    _afterSave: function(response) {
        this.model.set('locked', false);

        if (response &&
            !response.success &&
            response.validation_result &&
            response.validation_result.errors.length > 0 &&
            response.validation_result.errors[0].code
        ) {
            var mapCodeErrorToErrorMessage = {
                'FeedDefectIds.Gen.FEED_NAME_CANNOT_BE_EMPTY': iget2('b-feed-edit-popup', 'empty-name-error', 'Не указано название фида'),
                'FeedDefectIds.Gen.FEED_INVALID_HREF': iget2('b-feed-edit-popup', 'format-url-error', 'Неправильный формат ссылки'),
                'FeedDefectIds.Gen.FEED_PASSWORD_CANNOT_BE_EMPTY': iget2('b-feed-edit-popup', 'empty-password-error', 'Не указан пароль'),
                'FeedDefectIds.Gen.FEED_LOGIN_CANNOT_BE_EMPTY': iget2('b-feed-edit-popup', 'empty-login-error', 'Не указан логин'),
                'FeedDefectIds.Gen.FEED_PASSWORD_IS_NOT_SET': iget2('b-feed-edit-popup', 'empty-password-error', 'Не указан пароль'),
                'FeedDefectIds.Gen.FEED_LOGIN_IS_NOT_SET': iget2('b-feed-edit-popup', 'empty-login-error', 'Не указан логин'),
                'CollectionDefectIds.Size.MAX_ELEMENTS_EXCEEDED': iget2('b-feed-edit-popup', 'max-feed-count-error', 'Достигнуто максимальное количество фидов'),
                'FeedDefectIds.Gen.FEED_INVALID_FILENAME': iget2('b-feed-edit-popup', 'filename-error', 'Поддерживаются только файлы: zip, gz, yml, csv, tsv, xml, xls, xlsx')
            }

            response = {
                error: {
                    message: mapCodeErrorToErrorMessage[response.validation_result.errors[0].code] ||
                        iget2('b-feed-edit-popup', 'oshibka-pri-sohranenii', 'Ошибка при сохранении')
                }
            };
        } else if (!response || !response.success) {
            response = {
                error: {
                    message: iget2('b-feed-edit-popup', 'oshibka-pri-sohranenii', 'Ошибка при сохранении')
                }
            };
        }

        response.error ?
            this.trigger('error', response.error) && this._renderErrors(response.error.message) :
            this.trigger('save');
    },

    /**
     * Выводит ошибки в блоке
     * @param {String} errors
     * @param {String} [type] тип ошибки (вывод в отдельный блок)
     * @private
     */
    _renderErrors: function(errors, type) {
        BEM.DOM.update(
            type ?
                this.elem('errors', 'type', type) :
                this.elem('errors', 'common', 'yes'),
            errors);
    }

});
