BEM.MODEL.decl({ name: 'b-feed-edit-popup', baseModel: 'vm-feed' }, {

    // статус валидности введенных данных
    isValid: {
        type: 'boolean',
        default: true
    },

    // поле блокировки интерфейса
    locked: {
        type: 'boolean',
        default: false
    },

    // поле блокировки полей авторизации
    lockedAuth: {
        type: 'boolean',
        default: false,
        dependsFrom: ['authRequired', 'locked'],
        calculate: function() {
            return this.get('locked') || !this.get('authRequired');
        }
    },

    // поле блокировки кнопки сохранить
    lockedSaveButton: {
        type: 'boolean',
        default: false,
        dependsFrom: ['isValid', 'locked'],
        calculate: function() {
            return this.get('locked') || !this.get('isValid');
        }
    }

}, {

    /**
     * Производит синхронизацию с DM, если модель не новая
     * @returns {BEM.MODEL}
     * @override базовый метод кидает исключение, если DM отсутствует
     */
    init: function() {
        !this.isNew() && this.__base.apply(this, arguments);

        // для того, чтобы появились звездочки надо принудительно перезаписать поле,
        // так как форматированное значение вычисляется при set поля и нет метода пересчета
        this.get('hasPassword') && (function(password) {
            this.set('password', '*').set('password', password);
        }).call(this, this.get('password'));

        return this;
    },

    /**
     * Предоставляет данные для сохранения на сервере
     * @returns {Object}
     */
    provideData: function() {
        var data = {
            name: this.get('name'),
            source: this.get('source'),
            business_type: this.get('business_type')
        };

        !this.isNew() && (data.feed_id = this.get('feedId'));

        // для добавления фида по ссылке указываются нужные поля
        if (data.source === 'url') {
            data.url = this.get('url');
            data.is_remove_utm = this.get('removeUTM') ? 1 : 0;

            if (this.get('authRequired')) {
                data.login = this.get('login');
                data.password = this.get('password');
            }
        }

        return data;
    }

});
