block('b-feed-filter-edit').elem('filter-prices').elemMod('media-type', 'dynamic').content()(function() {
    var filter = this.ctx.filter || {};

    return u._.compact([
        !filter.strategy.name && !filter.strategy.is_autobudget && {
            elem: 'setting',
            elemMods: {
                field: 'price',
                single: 'yes'
            },
            fieldName: 'price',
            controlType: 'input',
            title: iget2('b-feed-filter-edit', 'bid-currency', 'Ставка, {foo}', {
                foo: u.formatCurrency(this.ctx.filter.currency)
            }),
            control: {
                block: 'input',
                mix: [
                    {
                        block: 'b-feed-filter-edit',
                        elem: 'type',
                        elemMods: { type: 'input' }
                    },
                    {
                        block: 'b-feed-filter-edit',
                        elem: 'price-input'
                    }
                ],
                value: u.numberFormatter.format(filter.price),
                mods: { clear: 'no' },
                content: [
                    {
                        elem: 'control'
                    }
                ]
            }
        },

        filter.strategy.name == 'different_places' && !filter.strategy.is_autobudget && (
            {
                elem: 'prices',
                filter: filter
            }
        )
    ]);
});

block('b-feed-filter-edit').elem('prices').content()(function() {
    var filter = this.ctx.filter,
        strategy = filter.strategy;

    return [
        !strategy.is_search_stop && {
            elem: 'setting',
            elemMods: { field: 'price' },
            fieldName: 'price',
            controlType: 'input',
            title: iget2('b-feed-filter-edit', 'stavka-na-poiske-s', 'Ставка на поиске, {foo} ', {
                foo: u.formatCurrency(filter.currency)
            }),
            control: {
                block: 'input',
                mix: [{
                    block: 'b-feed-filter-edit',
                    elem: 'type',
                    elemMods: { type: 'input' }
                }],
                value: u.numberFormatter.format(filter.price),
                mods: { clear: 'no' },
                content: { elem: 'control' }
            }
        },
        {
            elem: 'setting',
            elemMods: { field: 'price_context' },
            fieldName: 'price_context',
            controlType: 'input',
            title: iget2('b-feed-filter-edit', 'stavka-v-setyah-s', 'Ставка в сетях, {foo} ', {
                foo: u.formatCurrency(filter.currency)
            }),
            control: {
                block: 'input',
                mix: [{
                    block: 'b-feed-filter-edit',
                    elem: 'type',
                    elemMods: { type: 'input' }
                }],
                value: u.numberFormatter.format(filter.price_context),
                mods: { clear: 'no' },
                content: { elem: 'control' }
            }
        }
    ];
});
