block('b-feed-filter-edit').elem('filter-prices').elemMod('media-type', 'performance').content()(function() {
    var isCPAStrategy = this.ctx.filter.strategy.name.match('_cpa_'),
        currentOpt = (this.ctx.filter.now_optimizing_by || 'cpc').toLowerCase();

    return (isCPAStrategy ? ['cpa'] : ['cpc']).map(function(priceField) {
        var field = 'price_' + priceField;

        return {
            elem: 'setting',
            elemMods: {
                field: u.beminize(field),
                active: isCPAStrategy && currentOpt == priceField ? 'yes' : ''
            },
            fieldName: field,
            controlType: 'formatted-input',
            title: priceField.toUpperCase(),
            subTitle: u.formatCurrency(this.ctx.filter.currency),
            control: {
                block: 'input',
                mix: [
                    {
                        block: 'b-feed-filter-edit',
                        elem: 'type',
                        elemMods: { type: 'input' }
                    },
                    {
                        block: 'b-feed-filter-edit',
                        elem: 'price-input'
                    }
                ],
                value: u.numberFormatter.format(this.ctx.filter[field]) || '',
                content: { elem: 'control' }
            }
        };
    }, this);
});
