block('b-feed-filter-edit').elem('filter-settings-target').def()(function() {
    var ctx = this.ctx,
        isAnyCategory = !!ctx.categories && !!ctx.categories.length,
        feedType = ctx.feedType,
        businessType = ctx.businessType,
        tabs = u.feedFilterData.getTabs(feedType, businessType),
        activeTab = isAnyCategory ? (ctx.filter.tab || u.feedFilterData.defaultTab) : (ctx.filter.tab || tabs[0].value);

    return applyCtx([
        {
            elem: 'row',
            content: [
                {
                    elem: 'row-title'
                },
                {
                    elem: 'row-content',
                    content: {
                        block: 'tabs',
                        mix: { block: 'b-feed-filter-edit', elem: 'settings-tabs' },
                        panes: 'settings-target',
                        mods: { control: 'buttons', size: 's', theme: 'normal' },
                        content: tabs.map(function(tab) {
                            return {
                                elem: 'tab',
                                content: tab.title,
                                elemMods: {
                                    active: tab.value == activeTab ? 'yes' : '',
                                    disabled: (tab.value == 'tree' && !isAnyCategory) ? 'yes' : ''
                                }
                            }
                        }, this)
                    }
                }
            ]
        },
        {
            block: 'tabs-panes',
            id: 'settings-target',
            content: tabs.map(function(tab) {
                return {
                    elem: 'pane',
                    content: {
                        block: 'b-feed-filter-edit',
                        elem: 'filter-target-settings',
                        elemMods: { type: tab.value },
                        filter: ctx.filter,
                        isSingleTab: tabs.length == 1,
                        categories: ctx.categories
                    },
                    elemMods: { active: tab.value == activeTab ? 'yes' : '' }
                };
            }, this)
        }
    ])
});
