BEM.DOM.decl({ name: 'b-feed-filter-edit', modName: 'page', modVal: 'campaign' }, {
    onSetMod: {
        js: function() {
            this.__base();

            u.graspSelf.call(this, {
                _delete: 'button on delete',
                _suspend: 'tumbler on suspend'
            });

            this._delete.on('click', this._tryToDeleteFilter, this);
            this._suspend.on('change', this._tryToSuspendFilter, this);
        }
    },

    /**
     * Удаляет фильтр если он не является единственным активным, иначе показывает окно с сообщением
     *
     * @private
     */
    _tryToDeleteFilter: function() {
        if (!this.model.get('is_suspended') && this.params.isOneActiveFilterInGroup) {
            BEM.blocks['b-confirm'].alert(iget2('b-feed-filter-edit', 'nelzya-udalit-posledniy-filtr', 'Нельзя удалить последний фильтр'));

            return;
        }

        this.model.set('is_deleted', true);
    },

    /**
     * Выключает фильтр если он не является единственным активным, иначе показывает окно с сообщением
     *
     * @param {Object} e событие переключения тумблера
     * @param {Object} data
     * @param {Boolean} data.checked выключен или включен тумблер
     * @private
     */
    _tryToSuspendFilter: function(e, data) {
        if (!data.checked && this.params.isOneActiveFilterInGroup && !this.model.fields.is_suspended.getFixedValue()) {
            //afterCurrentEvent нужен для корректного переключения тумблера.
            //Если переключать синхронно в обработчике, то это изменение будет перетерто предыдущим значением
            //т.к. setMod сначала вызывает обработчики и лишь затем выставляет модификатор
            this.afterCurrentEvent(function() {
                this._suspend.setMod('checked', 'yes');
            }, this);

            BEM.blocks['b-confirm'].alert(iget2('b-feed-filter-edit', 'nelzya-vyklyuchit-posledniy-filtr', 'Нельзя выключить последний фильтр'));

            return;
        }

        this.model.set('is_suspended', !data.checked);
    }

});
