block('b-feed-filter-edit')(
    js()(function() {
        return {
            isOneActiveFilterInGroup: this.ctx.isOneActiveFilterInGroup,
            errorPath: 'filter',
            feedType: this.ctx.feedType,
            businessType: this.ctx.businessType,
            modelParams: {
                name: 'b-feed-filter-edit',
                data: {
                    categoriesExist: !!this.ctx.filter.feed.categories && !!this.ctx.filter.feed.categories.length,
                    filter_id: this.ctx.filter ? this.ctx.filter.filter_id : null,
                    adgroupModelId: this.ctx.filter.adgroupModelId,
                    adgroup_type: this.ctx.filter.adgroup_type,
                    skipPrices: this.mods['no-prices'] == 'yes',
                    skipRetargeting: this.ctx.noRetargeting,
                    skipAudience: this.ctx.noTargetAudience,
                    target_funnel: u._.pick(
                        this.ctx.filter,
                        ['target_funnel', 'filter_id', 'adgroup_id', 'adgroup_type', 'adgroupModelId']
                    )
                }
            }
        };
    }),

    mix()(function() {
        return { block: 'b-error-presenter' }
    }),

    content()(function() {
        return [
            {
                elem: 'header',
                mix: { block: 'b-modal-popup-decorator', elem: 'header' },
                content: [
                    {
                        elem: 'header-title',
                        content: iget2('b-feed-filter-edit', 'nastroyka-filtra-dlya-fida', 'Настройка фильтра для фида')
                    },
                    {
                        block: 'b-help-link',
                        mods: { type: 'modal' },
                        stretched: true,
                        url: this.ctx.hintUrl || u.getHelpUrl('smart-banners-feed-filters')
                    },
                    {
                        elem: 'header-update-time',
                        content: iget2('b-feed-filter-edit', 'poslednee-obnovlenie', 'Последнее обновление') + ': ' +
                            u.moment(this.ctx.filter.feed.last_refreshed).format('DD.MM.YYYY HH:mm')
                    }
                ]
            },
            {
                elem: 'body',
                mix: { block: 'b-modal-popup-decorator', elem: 'body' },
                content: [
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'row-title',
                                content: iget2('b-feed-filter-edit', 'nazvanie', 'Название')
                            },
                            {
                                elem: 'row-content',
                                content: {
                                    elem: 'filter-name',
                                    filter: this.ctx.filter
                                }
                            }
                        ]
                    },
                    this.mods['no-prices'] !== 'yes' && {
                        elem: 'row',
                        content: [
                            {
                                elem: 'row-title',
                                content: '&nbsp;'
                            },
                            {
                                elem: 'row-content',
                                content: {
                                    elem: 'filter-prices',
                                    elemMods: { 'media-type': this.ctx.filter.adgroup_type },
                                    filter: this.ctx.filter,
                                    showCPC: true,
                                    showCPA: true
                                }
                            }
                        ]
                    },
                    !this.ctx.noTargetAudience && {
                        elem: 'row',
                        content: [
                            {
                                elem: 'row-title',
                                content: iget2('b-feed-filter-edit', 'celevaya-auditoriya', 'Целевая аудитория')
                            },
                            {
                                elem: 'row-content',
                                content: {
                                    block: 'b-feed-filter-target-funnel',
                                    mix: {
                                        block: 'b-feed-filter-edit',
                                        elem: 'setting',
                                        elemMods: { field: 'filter-target-audience' }
                                    },
                                    filter: this.ctx.filter
                                }
                            }
                        ]
                    },
                    !this.ctx.noRetargeting && {
                        elem: 'row',
                        elemMods: { setting: 'retargeting' },
                        content: [
                            {
                                elem: 'row-title',
                                content: iget2('b-feed-filter-edit', 'uslovie-podbora', 'Условие подбора')
                            },
                            {
                                elem: 'row-content',
                                content: {
                                    elem: 'filter-retargeting-area',
                                    elemMods: {
                                        disabled: this.mods.cantsave
                                    }
                                }
                            }
                        ]
                    },
                    {
                        elem: 'filter-target-settings-area',
                        content: {
                            block: 'spin',
                            mix: {
                                block: 'b-feed-filter-edit',
                                elem: 'spin'
                            },
                            mods: { theme: 'gray-32', progress: 'yes' }
                        }
                    },
                    (this.ctx.feedType === 'YandexMarket') && {
                        elem: 'row',
                        elemMods: { plain: 'yes' },
                        content: [
                            {
                                elem: 'row-title'
                            },
                            {
                                elem: 'row-content',
                                content: [
                                    {
                                        block: 'checkbox',
                                        mods: {
                                            checked: this.ctx.filter.available ? 'yes' : ''
                                        },
                                        mix: [
                                            {
                                                block: 'b-feed-filter-edit',
                                                elem: 'available-checkbox'
                                            },
                                            {
                                                block: 'b-feed-filter-edit',
                                                elem: 'model-field',
                                                js: { name: 'available', type: 'checkbox' }
                                            }
                                        ],
                                        text: iget2('b-feed-filter-edit', 'tolko-v-nalichii', 'Только в наличии')
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                content: [
                    {
                        block: 'button',
                        mods: { disabled: 'yes', theme: 'action' },
                        mix: { block: 'b-feed-filter-edit', elem: 'save' },
                        content: [
                            {
                                block: 'b-feed-filter-edit',
                                elem: 'save-caption',
                                tag: 'span',
                                content: iget2('b-feed-filter-edit', 'sohranit', 'Сохранить')
                            },
                            {
                                block: 'b-feed-filter-edit',
                                elem: 'saving-caption',
                                tag: 'span',
                                content: [iget2('b-feed-filter-edit', 'sohranyaetsya', 'Сохраняется') + '...']
                            }
                        ]
                    },
                    {
                        block: 'button',
                        mix: { block: 'b-feed-filter-edit', elem: 'cancel' },
                        content: iget2('b-feed-filter-edit', 'otmena', 'Отмена')
                    },
                    {
                        elem: 'addition-controls',
                        elemMods: {
                            disabled: this.mods.cantsave
                        },
                        filter: this.ctx.filter
                    },
                    {
                        elem: 'goods-info-item',
                        content: iget2('b-feed-filter-edit', 'tovarov-v-fide', 'Товаров в фиде') + ': ' + this.ctx.filter.feed.offers_count
                    },
                    {
                        block: 'b-error-message',
                        js: { path: 'feed-filter-edit' }
                    },
                    { elem: 'edit-status' }
                ]
            }
        ];
    })
);
