BEM.MODEL.decl({ name: 'b-feed-filter-edit', baseModel: 'vm-feed-filter' }, {
    condition: {
        type: 'models-list',
        modelName: 'filter-condition-edit'
    },

    conditionTree: {
        type: 'models-list',
        modelName: 'filter-condition-edit'
    },

    filter_name: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    text: iget2('b-feed-filter-edit', 'ukazhite-nazvanie', 'Укажите название')
                },
                maxLength: {
                    value: 100,
                    text: iget2('b-feed-filter-edit', 'prevyshena-maksimalnaya-dlina-s', 'Превышена максимальная длина {foo} символов', {
                        foo: 100
                    }),
                    needToValidate: function(val) {
                        return !!val;
                    }
                },
                hasOnlyAllowedSymbols: {
                    text: iget2(
                        'b-feed-filter-edit',
                        'v-pravilah-dopuskaetsya-ispolzovanie-uzbekskogo',
                        'Допускается использование букв латинского, турецкого, русского, украинского, казахского, белорусского, узбекского алфавитов, цифр и знаков пунктуации'
                    ),
                    validate: function(val) {
                        return u.validation.isAllowedForBannerString(val);
                    }
                }
            }
        }
    },

    price_cpa: {
        type: 'number',
        format: function(value) {
            return u.numberFormatter.format(value) || '';
        },
        preprocess: function(val) {
            return this._preprocess(u.numberFormatter.clear(val));
        },
        validation: function() {
            var currency = this.get('currency'),
                currencyData = u.consts('currencies')[currency],
                min = currencyData.MIN_CPC_CPA_PERFORMANCE,
                max = currencyData.MAX_PRICE;

            return {
                rules: {
                    required: {
                        text: iget2('b-feed-filter-edit', 'ukazhite-cpc', 'Укажите CPC'),
                        needToValidate: function() {
                            // разрешено использовать ставку CPA по умолчанию в случаях:
                            //  - стратегия CPA на кампанию
                            //  - для стратегии задан filter_avg_cpa
                            var strategy = this.get('strategy'),
                                hasDefaultPrice = /^autobudget_avg_cpa_per_camp$/
                                    .test(strategy.name || strategy.net.name) || strategy.net.filter_avg_cpa > 0;

                            // поэтому в других случаях обязательно заполнение CPA
                            return !hasDefaultPrice;
                        }
                    },
                    lte: {
                        value: min,
                        text: iget2('b-feed-filter-edit', 'minimum-s', 'Минимум {foo}', {
                            foo: u.formatSumOfMoney(currency, min)
                        }),
                        needToValidate: function(value) {
                            // для CPA не надо валидировать нечисловые значения
                            if (isNaN(value)) return false;

                            return true;
                        }
                    },
                    gte: {
                        value: max,
                        text: iget2('b-feed-filter-edit', 'maksimum-s', 'Максимум {foo}', {
                            foo: u.formatSumOfMoney(currency, max)
                        }),
                        needToValidate: function(value) { return !isNaN(value); }
                    }
                },
                needToValidate: function() {
                    if (this.get('skipPrices') || this.get('adgroup_type') == 'dynamic') return false;

                    var strategy = this.get('strategy');

                    return ['autobudget_avg_cpa_per_camp', 'autobudget_avg_cpa_per_filter']
                        .indexOf(strategy.name || strategy.net.name) != -1;
                }
            };
        }
    },

    price_cpc: {
        type: 'number',
        format: function(value) {
            return u.numberFormatter.format(value) || '';
        },
        preprocess: function(val) {
            return this._preprocess(u.numberFormatter.clear(val));
        },
        validation: function() {
            var currency = this.get('currency'),
                currencyData = u.consts('currencies')[currency],
                min = currencyData.MIN_CPC_CPA_PERFORMANCE,
                max = currencyData.MAX_PRICE;

            return {
                rules: {
                    required: {
                        text: iget2('b-feed-filter-edit', 'ukazhite-cpc', 'Укажите CPC'),
                        needToValidate: function() {
                            // разрешено использовать ставку по умолчанию в случаях:
                            //  - стратегия CPC на кампанию
                            //  - для стратегии задан filter_avg_bid (ставка по умолчанию для стратегий CPC/CPA по каждому фильтру)
                            var strategy = this.get('strategy'),
                                hasDefaultPrice = /^autobudget_avg_cpc_per_camp$/
                                    .test(strategy.name || strategy.net.name) || strategy.net.filter_avg_bid > 0;

                            // поэтому в других случаях обязательно заполнение CPC
                            return !hasDefaultPrice;
                        }
                    },
                    lte: {
                        value: min,
                        text: iget2('b-feed-filter-edit', 'minimum-s', 'Минимум {foo}', {
                            foo: u.formatSumOfMoney(currency, min)
                        }),
                        needToValidate: function(value) { return !isNaN(value); }
                    },
                    gte: {
                        value: max,
                        text: iget2('b-feed-filter-edit', 'maksimum-s', 'Максимум {foo}', {
                            foo: u.formatSumOfMoney(currency, max)
                        }),
                        needToValidate: function(value) { return !isNaN(value); }
                    }
                },
                needToValidate: function() {
                    if (this.get('skipPrices') || this.get('adgroup_type') == 'dynamic') return false;

                    var strategy = this.get('strategy');

                    return /^autobudget_avg_cpc_per_(camp|filter)$/.test(strategy.name || strategy.net.name);
                }
            };
        }
    },

    /**
     * ставка на поиске
     */
    price: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currency = u.consts('currencies')[this.get('currency')],
                strategy = this.get('strategy'),
                needValidFlag = (!strategy.name && !strategy.is_autobudget) ||
                    (strategy.name == 'different_places' && !strategy.is_search_stop);

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2('b-feed-filter-edit', 'vvedeno-nekorrektnoe-znachenie-minimum', 'Введено некорректное значение. Минимум: {foo}', {
                            foo: currency.MIN_PRICE
                        }),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2('b-feed-filter-edit', 'ukazano-slishkom-bolshoe-znachenie', 'Указано слишком большое значение. Максимум: {foo}', {
                            foo: currency.MAX_PRICE
                        }),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                },
                needToValidate: function() {
                    return !this.get('skipPrices') && this.get('adgroup_type') == 'dynamic';
                }
            };
        }
    },

    /**
     * Ставка на контекстных площадках
     */
    price_context: {
        type: 'number',
        preprocess: function(val) {
            return u.numberFormatter.clear(val);
        },
        validation: function() {
            var currency = u.consts('currencies')[this.get('currency')],
                strategy = this.get('strategy'),
                needValidFlag = (strategy.name == 'different_places' && !strategy.is_autobudget);

            return {
                rules: {
                    lte: {
                        value: currency.MIN_PRICE,
                        text: iget2('b-feed-filter-edit', 'vvedeno-nekorrektnoe-znachenie-minimum', 'Введено некорректное значение. Минимум: {foo}', {
                            foo: currency.MIN_PRICE
                        }),
                        needToValidate: function() {
                            return needValidFlag;
                        }
                    },
                    gte: {
                        value: currency.MAX_PRICE,
                        text: iget2('b-feed-filter-edit', 'ukazano-slishkom-bolshoe-znachenie', 'Указано слишком большое значение. Максимум: {foo}', {
                            foo: currency.MAX_PRICE
                        }),
                        needToValidate: function(val) {
                            return needValidFlag && (val > currency.MIN_PRICE);
                        }
                    }
                },
                needToValidate: function() {
                    return !this.get('skipPrices') && this.get('adgroup_type') == 'dynamic';
                }
            };
        }
    },

    hasChanges: {
        type: 'boolean',
        default: false
    },

    skipPrices: {
        type: 'boolean',
        internal: true,
        default: false
    },

    /**
     * флаг, указывающий на состояние процесса сохранения
     */
    isSaving: {
        type: 'boolean',
        internal: true,
        default: false
    },

    /**
     * флаг, можно ли задать условие ретаргетинга для фильтра
     */
    isRetargetingAvailable: {
        type: 'boolean',
        dependsFrom: 'target_funnel',
        internal: true,
        calculate: function() {
            var targetFunnelModel = this.get('target_funnel');

            return targetFunnelModel.get('target_funnel') == 'same_products';
        }
    },

    /**
     * флаг, есть ли категории в фиде
     */
    categoriesExist: {
        type: 'boolean',
        internal: 'true'
    },

    /**
     * Не показывать блок с ретаргетингом
     */
    skipRetargeting: {
        type: 'boolean',
        internal: false
    },

    target_funnel: {
        type: 'model',
        modelName: 'b-feed-filter-target-funnel',
        validation: {
            rules: {
                required: {
                    validate: function() {
                        return this.get('target_funnel').isValid();
                    }
                }
            }
        }
    }
}, {
    isTreeTab: function() {
        return this.get('tab') == 'tree';
    },

    /**
     * Возвращает объект с данными фида
     * @returns {$.Deferred<Object>}
     */
    getFeedData: function() {
        var feedDM = this.getParentGroupDM().getFeedDM();

        return feedDM ? feedDM.toJSON() : {};
    },

    prepareDataFromDM: function(data) {
        var isConditionTab = !this.get('categoriesExist') || data.from_tab == 'condition',
            treeData = data.condition_tree && data.condition_tree.length && !isConditionTab ?
                data.condition_tree : [],
            rels = {
                categoryId: '==',
                price: '<->',
                vendor: 'ilike'
            },
            businessType = this.getFeedData().business_type,
            feedType = this.getFeedData().feed_type;

        // Выяснил в ходе разговора с менеджером что данные поля доступны для фида YandexMarket
        if (feedType == 'YandexMarket') {
            ['categoryId', 'price', 'vendor'].map(function(field) {
                var index = u._.findIndex(treeData, function(cond) {
                    return cond.field === field;
                });

                if (index == -1) {
                    treeData.push({
                        id: u._.uniqueId('tree_condition_id_'),
                        field: field,
                        relation: rels[field],
                        value: []
                    });
                } else {
                    //для не-древесного вида id генерируются при добавлении условий в список в композите
                    treeData[index].id = treeData[index].id || u._.uniqueId('tree_condition_id_');
                }
            });
        }

        return u._.extend(data, {
            conditionTree: u['i-filter-edit__preprocess'].serverToClient(treeData),
            condition: u['i-filter-edit__preprocess'].serverToClient(data.condition || []),
            tab: isConditionTab ?
                'condition' :
                (data.from_tab || u.feedFilterData.getTabs(feedType, businessType)[0].value),
            target_funnel: u._.pick(data, ['target_funnel', 'filter_id', 'adgroup_id', 'adgroup_type', 'adgroupModelId'])
        });
    },

    prepareDataToDM: function(data) {
        var result = u._.extend(data, {
            conditionsState: this.getConditionsState(),
            filter_id: this.id,
            from_tab: data.tab,
            condition_tree: u['i-filter-edit__preprocess'].clientToServer(data.conditionTree, true),
            condition: u['i-filter-edit__preprocess'].clientToServer(data.condition),
            retargetings: this.get('isRetargetingAvailable') ? data.retargetings : [],
            target_funnel: data.target_funnel.target_funnel
        });

        return u._.omit(result, 'conditionTree');
    }
});
