BEM.MODEL.decl({ model: 'b-feed-filter-target-funnel_multi_yes', baseModel: 'b-feed-filter-target-funnel' }, {
    //id кампании, в которой происходит мультиредактирование
    cid: 'string',

    // подсказка о счетчиках метрики
    metrikaWarning: {
        type: 'enum',
        enum: ['hidden', 'no-data', 'ecommerce', 'not-available-on-search', 'similar-products', 'targeting-only-on-net'],
        default: 'hidden',
        dependsFrom: ['target_funnel', 'cid', 'adgroup_type'],
        calculate: function() {
            //если не определены adgroup_id и adgroup_type модель не проинициализированна до конца и пока возвращаем дефолтное значение
            if (!this.get('cid') || !this.get('adgroup_type')) {
                return 'hidden';
            }

            var campaignDM = this.getParentCampaignDM(),
                strategy = campaignDM.get('strategy'),
                isSearchSelected = strategy.is_net_stop,
                isBothSelected = !strategy.is_search_stop && !strategy.is_net_stop,
                target = this.get('target_funnel');

                // если стратегия настроена на "поиск" и выбрана целевая аудитория "Смотрели товары на моем сайте" (блокируется кнопка сохранения)
            if (isSearchSelected && target === 'product_page_visit') {
                return 'not-available-on-search';
            } else if (!campaignDM.get('metrika_counters')) {
                return 'no-data';

                 // если стратегия настроена на "поиск + сеть" и выбрана целевая аудитория "Смотрели товары на моем сайте"
            } else if (isBothSelected && target === 'product_page_visit') {
                return 'targeting-only-on-net';

                // если стратегия настроена на "поиск" или на "поиск + сеть" и выбрана целевая аудитория "Обе группы"
            } else if ((isSearchSelected || isBothSelected) && target === 'same_products') {
                return 'similar-products';
            } else if (this.get('target_funnel') === 'product_page_visit' &&
                !campaignDM.get('metrika').get('ecommerce')) {
                return 'ecommerce';
            }

            return 'hidden';
        }
    }
}, {
    /**
     * Возвращает родительскую модель кампании
     * @returns {BEM.MODEL}
     */
    getParentCampaignDM: function() {
        return BEM.MODEL.getOne({
            name: u.campaign.getCampaignModelName(this.get('adgroup_type')),
            id: this.get('cid')
        });
    }
});
