block('b-feed-filter-target-funnel')(
    js()(function() {
        return {
            modelParams: {
                name: 'b-feed-filter-target-funnel',
                id: this.ctx.filter.filter_id
            }
        }
    }),
    content()(function() {
        var filter = this.ctx.filter || {};

        return [
            {
                block: 'select',
                value: filter.target_funnel,
                mix: {
                    block: 'b-feed-filter-target-funnel',
                    elem: 'select'
                },
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: Object.keys(u.feedFilterData.targetAudienceTitles).map(function(value) {
                            return {
                                elem: 'option',
                                attrs: filter.target_funnel == value ?
                                    { value: value, selected: 'selected' } :
                                    { value: value },
                                content: u.feedFilterData.targetAudienceTitles[value]
                            };
                        })
                    }
                ]
            },
            {
                elem: 'metrika-warning',
                content: [
                    {
                        block: 'icon-text',
                        mods: { theme: 'info', size: 'ms' },
                        mix: {
                            block: 'b-feed-filter-target-funnel',
                            elem: 'warning',
                            elemMods: {
                                type: 'no-data'
                            }
                        },
                        text: iget2(
                            'b-feed-filter-target-funnel',
                            'dlya-korrektnoy-nastroyki-pokazov',
                            'Для корректной настройки показов для этой целевой аудитории укажите счётчик Метрики в параметрах кампании.'
                        )
                    },
                    {
                        block: 'icon-text',
                        mods: { theme: 'info', size: 'ms' },
                        mix: {
                            block: 'b-feed-filter-target-funnel',
                            elem: 'warning',
                            elemMods: {
                                type: 'ecommerce'
                            }
                        },
                        text: iget2(
                            'b-feed-filter-target-funnel',
                            'nekorrektno-nastroena-peredacha-dannyh',
                            'Некорректно настроена передача данных Ecommercе'
                        )
                    },
                    {
                        block: 'icon-text',
                        mods: { theme: 'info', size: 'ms' },
                        mix: {
                            block: 'b-feed-filter-target-funnel',
                            elem: 'warning',
                            elemMods: {
                                type: 'not-available-on-search'
                            }
                        },
                        text: iget2(
                            'b-feed-filter-target-funnel',
                            'dannii-vid-targetinga-nedostypen-pri-pokazah-na-poiske',
                            'Данный вид таргетинга недоступен при показах на поиске'
                        )
                    },
                    {
                        block: 'icon-text',
                        mods: { theme: 'info', size: 'ms' },
                        mix: {
                            block: 'b-feed-filter-target-funnel',
                            elem: 'warning',
                            elemMods: {
                                type: 'similar-products'
                            }
                        },
                        text: iget2(
                            'b-feed-filter-target-funnel',
                            'na-poiske-obyavlenia-bydyt-pokazani-tolko-ayditorii',
                            'На поиске объявления будут показаны только аудитории, интересующейся похожими товарами'
                        )
                    },
                    {
                        block: 'icon-text',
                        mods: { theme: 'info', size: 'ms' },
                        mix: {
                            block: 'b-feed-filter-target-funnel',
                            elem: 'warning',
                            elemMods: {
                                type: 'targeting-only-on-net'
                            }
                        },
                        text: iget2(
                            'b-feed-filter-target-funnel',
                            'targeting-tolko-v-setyah',
                            'Данный таргетинг будет применяться только к показам в сетях'
                        )
                    }
                ]
            }
        ];
    })
);
