BEM.DOM.decl({ block: 'b-feed-filter-target-funnel' }, {

    initBlock: function() {
        if (this.params.modelData) {
            this.model = BEM.MODEL.create(this.params.modelParams, this.params.modelData);
        } else {
            this.model = BEM.MODEL.getOrCreate(this.params.modelParams);
        }

        this.select = this.findBlockOn(this.elem('select'), 'select');

        this.select.on('change', function() {
            this.model.set('target_funnel', this.select.val());
        }, this);

        this.model.on('target_funnel', 'change', function() {
            this.select.getMod('focused') !== 'yes' && this.select.val(this.getTargetFunnel());
        }, this);

        this.model.on('metrikaWarning', 'change', function() {
            this.setMod(this.elem('metrika-warning'), 'type', this.model.get('metrikaWarning'));
        }, this);

        this.setMod(this.elem('metrika-warning'), 'type', this.model.get('metrikaWarning'));

        return this;
    },

    /**
     * Возвращает значение целевой аудитории
     * @returns {String}
     */
    getTargetFunnel: function() {
        return this.model.get('target_funnel');
    },

    /**
     * Удаление блока
     * @returns {BEM}
     */
    destruct: function() {
        this.model && this.model.destruct();

        return this.__base.apply(this, arguments);
    }
}, {

});
