BEM.MODEL.decl({ name: 'b-feed-filter-target-funnel' }, {
    // клиентский идентификатор фильтра (изначально соответствует реальному и не меняется в модели)
    filter_id: 'id',

    // целевая аудитория
    target_funnel: {
        type: 'string',
        validation: {
            rules: {
                required: {
                    validate: function() {
                        var strategy = this.getParentModel().get('strategy'),
                            isSearchSelected = strategy.is_net_stop,
                            target = this.get('target_funnel');

                        // не разрешаем сохранить фильтр, когда стратегия выбрана на "поиск" и выбрана целевая аудитория "Смотрели товары на моем сайте"
                        return !(isSearchSelected && target === 'product_page_visit');
                    }
                }
            }
        }
    },

    adgroup_type: 'string',

    adgroup_id: 'string',

    adgroupModelId: 'string',

    // подсказка о счетчиках метрики
    metrikaWarning: {
        type: 'enum',
        enum: ['hidden', 'no-data', 'ecommerce', 'not-available-on-search', 'similar-products', 'targeting-only-on-net'],
        default: 'hidden',
        dependsFrom: ['target_funnel', 'adgroup_id', 'adgroup_type', 'adgroupModelId'],
        calculate: function() {
            //если не определены adgroup_id и adgroup_type модель не проинициализированна до конца и пока возвращаем дефолтное значение
            if (!this.get('adgroupModelId') || !this.get('adgroup_type')) {
                return 'hidden';
            }

            var groupDm = this.getParentGroupDM(),
                campaignModel = groupDm.getCampaignModel(),
                strategy = campaignModel.get('strategy'),
                isSearchSelected = strategy.is_net_stop,
                isBothSelected = !strategy.is_search_stop && !strategy.is_net_stop,
                target = this.get('target_funnel');

            // если стратегия настроена на "поиск" и выбрана целевая аудитория "Смотрели товары на моем сайте" (блокируется кнопка сохранения)
            if (isSearchSelected && target === 'product_page_visit') {
                return 'not-available-on-search';
            } else if (!groupDm.getMetrikaCounters()) {
                return 'no-data';

                // если стратегия настроена на "поиск + сеть" и выбрана целевая аудитория "Смотрели товары на моем сайте"
            } else if (isBothSelected && target === 'product_page_visit') {
                return 'targeting-only-on-net';

                // если стратегия настроена на "поиск" или на "поиск + сеть" и выбрана целевая аудитория "Обе группы"
            } else if ((isSearchSelected || isBothSelected) && target === 'same_products') {
                return 'similar-products';
            } else if (
                this.get('target_funnel') === 'product_page_visit' &&
                !campaignModel.get('metrika').get('ecommerce')
            ) {
                return 'ecommerce';
            }

            return 'hidden';
        },
    },

    _dmDecl: {
        type: 'object',
        internal: true,
        calculate: function() {
            return {
                name: 'dm-feed-filter',
                id: this.get('filter_id')
            };
        }
    }
}, {
    getParentGroupDM: function() {
        return BEM.MODEL.getOne({
            name: u.campaign.getGroupModelName(this.get('adgroup_type')),
            id: this.get('adgroupModelId')
        });
    }
});
