block('b-feed-filter').mod('detailed', 'yes')(

    js()(true),

    content()(function() {

        return [
            {
                elem: 'name-row',
                content: [
                    {
                        elem: 'name',
                        elemMods: {
                            error: this.ctx.filter.isIncorrect ? 'yes' : ''
                        },
                        mix: {
                            block: 'b-feed-filter',
                            elem: 'field'
                        },
                        content: u.escapeHtmlSafe(this.ctx.filter.filter_name)
                    },
                    {
                        elem: 'edit',
                        mix: {
                            block: 'b-feed-filter',
                            elem: 'field'
                        },
                        content: this.ctx.editControl
                    },

                    this.ctx.filter.isIncorrect && {
                        block: 'icon-text',
                        mods: { size: 'ms', theme: 'alert' },
                        mix: {
                            block: 'b-feed-filter',
                            elem: 'errors'
                        },
                        text: {
                            block: 'link',
                            mix: {
                                block: 'b-feed-filter',
                                elem: 'errors-link'
                            },
                            mods: { pseudo: 'yes' },
                            content: iget2('b-feed-filter', 'oshibki-filtra', 'Ошибки фильтра')
                        }
                    }
                ]
            },
            !this.ctx.noTargetAudience && {
                elem: 'target-audience',
                filter: this.ctx.filter
            },
            !this.ctx.noRetargeting && !!this.ctx.filter.retargetings.length && {
                elem: 'retargeting',
                filter: this.ctx.filter
            }
        ];
    })
);
