BEM.DOM.decl({ block: 'b-feed-filter', modName: 'detailed', modVal: 'yes' }, {

    /**
     * Возвращает блок попапа
     * @returns {BEM<b-shared-popup>}
     * @private
     */
    _getErrorsPopup: function() {

        return this._errorsPopup || (this._errorsPopup = BEM.blocks['b-shared-popup'].getInstance({
            adaptive: 'yes'
        }, {
            directions: ['right', 'top']
        }));
    },

    /**
     * Возвращает содержимое для попапа
     * @returns {String}
     * @private
     */
    _getPopupContent: function() {

        return BEMHTML.apply({
            block: 'b-feed-filter',
            elem: 'error-desc',
            content: [
                {
                    elem: 'error-title',
                    content: iget2('b-feed-filter', 'nekorrektnye-usloviya-filtracii-kategorii', 'Некорректные условия фильтрации: категории не выбраны.')
                },
                iget2('b-feed-filter', 'rekomenduem-vypolnit-odno-iz', 'Рекомендуем выполнить одно из действий:'),
                [
                    iget2('b-feed-filter', 'zamenit-fid', 'Заменить фид'),
                    iget2('b-feed-filter', 'ukazat-v-usloviyah-filtracii', 'Указать в условиях фильтрации другие категории'),
                    iget2('b-feed-filter', 'zadat-usloviya-filtracii-na', 'Задать условия фильтрации на вкладке \'Условия\'')
                ].map(function(text) {
                    return {
                        elem: 'error-tip',
                        content: text
                    };
                })
            ]
        });
    }

});
