/**
 * Событие завершения редактирования фильтра
 * @event b-feed-filter#filter:edit:completed
 * @type {Object}
 * @property {FilterEditData} modelData
 * @property {FilterValidationController} controller
 */

/**
 * @fires b-feed-filter#filter:edit:completed
 */
BEM.DOM.decl({ block: 'b-feed-filter', modName: 'editable', modVal: 'yes' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            // из-за перестроения списка изменений происходит несколько, перерисовываемся только 1 раз
            this.model.init().fix()
                .on('change', $.debounce(function() {
                    this.toggleMod(this.elem('retargeting'), 'hidden', 'yes', !this.model.get('retargetings').length);
                }, 0), this)
                .getDM()
                .on('filter_name target_funnel', 'change', function(e, data) {
                    this.model.set(data.field, data.value);
                }, this)
        },

        'fetching-data': function(modName, modVal) {
            this._spin || (this._spin = this.findBlockOn('fetch-data-spin', 'spin'));

            this._spin.toggleMod('progress', 'yes', !!modVal);
        }

    },

    /**
     * Открывает попап редактирования фильтра
     */
    openEditPopup: function() {
        // редактирование не должно прерываться для предотвращения потери введенных данных
        if (this.hasMod('fetching-data', 'yes')) return;

        var dna = window.dna;

        if (!dna) {
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        this.setMod('fetching-data', 'yes');

        if (this._groupFilterInspectorModal) {
            BEM.DOM.destruct(this._groupFilterInspectorModal);
        }

        this._groupFilterInspectorModal = BEM.DOM.append($('body'), BEMHTML.apply({
            block: 'group-filter-inspector-fake-block' // фейковый блок
        }));

        var dnaComp = dna.reactCreateElement(dna.components.GroupFilterInspectorWrapper, {
            groupId: this.model.get('adgroup_id'),
            filterId: this.model.get('filter_id'),
            campaignId: this.model.get('campaign_id'),
            onLoadedFeedFilter: function() {
                this.delMod('fetching-data');
            }.bind(this),
            afterSaveCallback: function(name, targetFunnel) {
                var mapTargetFunnelFromNewToOldDirect = {
                    SAME_PRODUCTS: 'same_products',
                    NEW_AUDITORY: 'new_auditory',
                    PRODUCT_PAGE_VISIT: 'product_page_visit'
                };

                this.model.update({
                    filter_name: name,
                    target_funnel: mapTargetFunnelFromNewToOldDirect[targetFunnel]
                });
            }.bind(this)
        }, null);

        dna.reactDOMRender(dnaComp, this._groupFilterInspectorModal[0]);
    },

    /**
     * Проверяет является ли условие нацеливания последним активным в группе
     *
     * @returns {Boolean} если true то последнее активное
     */
    isOneActiveFilterInGroup: function(groupDM) {
        var filters = groupDM.get('feed_filters');

        return filters.filter(function(filterModel) {
            return !filterModel.get('is_deleted') && !filterModel.get('is_suspended');
        }).length <= 1;
    }
});
