/**
 * Блок фильтра смарт-баннера
 *
 * @param {Object} filter объект фильтра (данные из модели)
 * @param {Object} filter.filter_name название фильтра
 * @param {Object} filter.target_funnel уровень воронки фильтра
 * @param {Object} filter.is_settings_editable флаг доступности редактирования фильтра
 * @param {Object} filter.is_suspended флаг о статусе приостановки
 */
block('b-feed-filter')(
    def()(function() {
        var filter = this.ctx.filter;

        return applyNext({
            'mods.editable': filter.is_settings_editable ? 'yes' : '',
            'mods.cantsave': filter.is_settings_cant_save ? 'yes' : '',
            'mods.is-suspended': filter.is_suspended ? 'yes' : ''
        });
    }),

    content()(function() {
        return [
            {
                elem: 'name',
                mix: {
                    block: 'b-feed-filter',
                    elem: 'field'
                },
                content: u.escapeHtmlSafe(this.ctx.filter.filter_name)
            },
            !this.ctx.noTargetAudience && {
                elem: 'target-audience',
                elemMods: {
                    hidden: !this.ctx.filter.target_funnel ? 'yes' : ''
                },
                mix: {
                    block: 'b-feed-filter',
                    elem: 'field'
                },
                filter: this.ctx.filter
            },
            !this.ctx.noRetargeting && {
                elem: 'retargeting',
                elemMods: {
                    hidden: u._.isEmpty(this.ctx.filter.retargetings) ? 'yes' : ''
                },
                mix: { block: 'b-feed-filter', elem: 'field' },
                filter: this.ctx.filter
            },
            {
                elem: 'warning',
                // показываем ошибку только когда выбрана стратегия на "поиск" и целевая аудитория "Смотрели на моем сайте"
                elemMods: { hidden: !(this.ctx.platform === 'search' && this.ctx.filter.target_funnel === 'product_page_visit') ? 'yes' : '' },
                filter: this.ctx.filter
            }
        ];
    }),

    elem('target-audience').content()(function() {
        return [
            iget2('b-feed-filter', 'celevaya-auditoriya', 'Целевая аудитория') + ': ',
            {
                elem: 'target-audience-value',
                content: u.feedFilterData.targetAudienceTitles[this.ctx.filter.target_funnel]
            }
        ];
    }),

    elem('retargeting').content()(function() {
        var result = (this.ctx.filter.retargetings || []).map(function(item) {
            return !u._.isEmpty(item) ? item.condition_name : '';
        }).join(', ');

        return [
            iget2('b-feed-filter', 'uslovie-podbora', 'Условие подбора') + ': ',
            {
                elem: 'retargeting-value',
                attrs: { title: u.escapeHtmlSafe(result) },
                content: u.hellipCut(result, 30, u.escapeHtmlSafe)
            }
        ];
    }),

    elem('target-audience-value').tag()('span'),

    elem('warning').content()(function() {
        return {
            block: 'icon-text',
            mods: { theme: 'alert', size: 'ms' },
            text: iget2(
                'b-feed-filter-target-funnel',
                'dannii vid targetinga nedostypen pri pokazah na poiske',
                'Данный вид таргетинга недоступен при показах на поиске. Расширьте целевую аудиторию'
            )
        }
    })
);
