BEM.DOM.decl({ block: 'b-feed-filter', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.model.on('target_funnel', 'change', this._targetFunnelChange, this);
        }
    },

    destruct: function() {
        this.model.un('target_funnel', this._targetFunnelChange);

        this.__base.apply(this, arguments);
    },

    _targetFunnelChange: function(e, data) {
        var isSearchSelected = this.model.get('strategy').is_net_stop;

        // Обрабатываем только те случаи, когда стратегия настроена на "поиск"
        if (!isSearchSelected) {
            return;
        }

        var elem = this.elem('warning');

        this.toggleMod(elem, 'hidden', 'yes', data.value !== 'product_page_visit');
    }
}, {
    live: function() {
        this
            .liveBindTo('name', 'click', function() {
                this.openEditPopup();
            })
            .liveBindTo('errors-link', 'click', function(e) {
                this._getErrorsPopup()
                    .setContent(this._getPopupContent())
                    .toggle($(e.target));
            });
        return false;
    }
});
