block('b-feed-filters-group')(

    mode('filters')([]),

    def()(function() {
        var filters = apply('filters').sort(function(filter1, filter2) {
            var val1 = (filter1.name || '').toLowerCase(),
                val2 = (filter2.name || '').toLowerCase();

            //для турции своя лексикографическая сортировка
            if (u.consts('lang') == 'tr') return u.sortTr(val1, val2);

            if (val1 < val2) return -1;

            if (val1 > val2) return 1;

            return 0;
        });

        return applyNext({
            'mods.hide-inactive': 'yes',
            'mods.editable-price': u._.some(filters, 'is_price_editable') ? 'yes' : this.mods['editable-price'],
            'mods.empty': filters.length ? this.mods.empty : 'yes',
            'ctx.feedFilters': filters
        });
    }),

    tag()('tbody'),

    js()(function() {
        return {
            modelData: {
                adgroup_type: this.ctx.group.adgroup_type,
                adgroup_id: this.ctx.group.adgroup_id
            }
        };
    }),

    mod('state', 'active')(
        mode('filters')(function() {
            return this.ctx.group.feed_filters.filter(function(filter) {
                return !filter.is_suspended;
            });
        }),

        // при наличии активных фильтров и включенной возможности редактировать цену,
        mod('editable-price', 'yes')(
            // добавляется контрол для группового редактирования
            content()(function() {
                return {
                    elem: 'row',
                    elemMods: {
                        type: 'multi-edit',
                        strategy: this.mods.strategy
                    },
                    group: this.ctx.group,
                    feedFilters: this.ctx.feedFilters
                };
            }),

            // для стратегии оптимизации конверсии нет контрола для группового редактирования,
            // но есть заголовки для колонок под 2 инпута
            mod('strategy', 'avg-cpa').content()(function() {
                return {
                    elem: 'row',
                    elemMods: { type: 'caption' },
                    content: ['gap-cell', 'column-caption'].map(function(type, i) {
                        return {
                            elem: 'cell',
                            elemMods: {
                                type: type,
                                strategy: this.mods.strategy,
                                highlight: i > 0 && this.ctx.nowOptimizingBy === ['', 'CPA'][i] ? 'yes' : ''
                            },
                            group: this.ctx.group,
                            content: ['', iget2('b-feed-filters-group', 'cpa', 'CPA')][i]
                        };
                    }, this)
                };
            }),

            // для стратегии раздельное размещение нет контрола для группового редактирования,
            // но есть заголовки для колонок под 2 инпута
            mod('strategy', 'different-places').content()(function() {
                return {
                    elem: 'row',
                    elemMods: { type: 'caption' },
                    content: ['gap-cell', 'column-caption', 'column-caption'].map(function(type, i) {
                        return {
                            elem: 'cell',
                            elemMods: {
                                type: type,
                                strategy: this.mods.strategy
                            },
                            group: this.ctx.group,
                            content: ['', iget2('b-feed-filters-group', 'na-poiske', 'На поиске'), iget2('b-feed-filters-group', 'v-setyah', 'В сетях')][i]
                        };
                    }, this)
                };
            })
        ),

        // если активных нет, то громко об этом вываливаем на страницу
        mod('empty', 'yes').content()({
            elem: 'row',
            elemMods: { type: 'empty' }
        })
    ),

    // перед списком неактивных размещаем кнопку для показа/скрытия неактивных фильтров
    mod('state', 'suspended')(
        mode('filters')(function() {
            return this.ctx.group.feed_filters.filter(function(filter) {
                return filter.is_suspended;
            });
        }),

        content()({
            elem: 'row',
            elemMods: {
                type: 'inactive-toggle'
            }
        }),

        // если неактивных нет, то просто ничего не выводим
        mod('empty', 'yes').def()('')
    ),

    content()(function() {
        return [
            // зависимый от состояния контент
            applyNext(),
            // список фильтров в соответствующем состоянии
            (this.ctx.feedFilters || []).map(function(filter, i) {
                return {
                    block: 'b-group-feed-filter',
                    mods: {
                        first: i == 0 ? 'yes' : '',
                        strategy: this.mods.strategy
                    },
                    mix: {
                        block: 'b-feed-filters-group',
                        elem: 'row',
                        elemMods: filter.is_suspended && {
                            inactive: 'yes'
                        }
                    },
                    group: this.ctx.group,
                    filter: filter,
                    nowOptimizingBy: this.ctx.nowOptimizingBy,
                    showStat: this.ctx.showStat,
                    campaignIsArchived: this.ctx.campaignIsArchived,
                    platform: this.ctx.platform
                };
            }, this)
        ];
    }),

    elem('inactive-toggler')(
        tag()('span'),

        elemMod('mode', 'hide').content()(function() {
            return iget2('b-feed-filters-group', 'skryt-otklyuchennye', 'Скрыть отключенные');
        }),

        elemMod('mode', 'show').content()(function() {
            return iget2('b-feed-filters-group', 'pokazat-otklyuchennye', 'Показать отключенные');
        })
    ),

    elem('row')(

        elemMod('type', 'empty').content()(function() {
            return {
                elem: 'cell',
                elemMods: { type: 'single' },
                content: iget2('b-feed-filters-group', 'net-aktivnyh-filtrov', 'Нет активных фильтров.')
            };
        }),

        elemMod('type', 'inactive-toggle').content()(function() {
            return {
                elem: 'cell',
                elemMods: { type: 'single' },
                content: {
                    block: 'button',
                    mods: {
                        size: 's',
                        arrow: 'down',
                        pseudo: 'yes'
                    },
                    mix: {
                        block: 'b-feed-filters-group',
                        elem: 'inactive-toggle-button'
                    },
                    content: ['hide', 'show'].map(function(mode) {
                        return {
                            block: 'b-feed-filters-group',
                            elem: 'inactive-toggler',
                            elemMods: { mode: mode }
                        };
                    })
                }
            };
        }),

        elemMod('type', 'multi-edit').content()(function() {
            return ['gap-cell', 'multi-edit-caption', 'multi-edit'].map(function(type) {
                return {
                    elem: 'cell',
                    elemMods: {
                        type: type,
                        strategy: this.mods.strategy
                    },
                    group: this.ctx.group,
                    feedFilters: this.ctx.feedFilters
                };
            }, this);
        })
    ),

    elem('cell')(
        elemMod('strategy', 'avg-cpc')(
            elemMod('type', 'multi-edit-caption').content()(function() { return [iget2('b-feed-filters-group', 'dlya-vseh-filtrov', 'Для всех фильтров'), ':']; }),

            elemMod('type', 'multi-edit').content()(function() {
                return {
                    block: 'b-edit-phrase-price',
                    mods: {
                        'control-type': 'cpc',
                        multiedit: 'yes'
                    },
                    campDMParams: {
                        id: this.ctx.group.cid,
                        name: u.campaign.getCampaignModelName(this.ctx.group.adgroup_type)
                    }
                };
            })
        ),

        elemMod('strategy', 'search')(
            elemMod('type', 'multi-edit-caption').content()(function() { return [iget2('b-feed-filters-group', 'dlya-vseh-filtrov', 'Для всех фильтров'), ':']; }),

            elemMod('type', 'multi-edit').content()(function() {
                return {
                    block: 'b-edit-phrase-price',
                    mods: {
                        'control-type': 'search',
                        multiedit: 'yes'
                    },
                    campDMParams: {
                        id: this.ctx.group.cid,
                        name: u.campaign.getCampaignModelName(this.ctx.group.adgroup_type)
                    }
                };
            })
        ),

        elemMod('strategy', 'net')(
            elemMod('type', 'multi-edit-caption').content()(function() { return [iget2('b-feed-filters-group', 'dlya-vseh-filtrov', 'Для всех фильтров'), ':']; }),

            elemMod('type', 'multi-edit').content()(function() {
                return {
                    block: 'b-edit-phrase-price',
                    mods: {
                        'control-type': 'context',
                        multiedit: 'yes'
                    },
                    campDMParams: {
                        id: this.ctx.group.cid,
                        name: u.campaign.getCampaignModelName(this.ctx.group.adgroup_type)
                    }
                };
            })
        ),

        elemMod('type', 'gap-cell')(
            def()(function() {
                return applyNext({
                    'ctx.adjustmentBounds': u['b-adjustment-rates-fork'].getBounds(this.ctx.group)
                });
            }),

            content()(
                match(function() { return true })('&nbsp;'),

                match(function() { return this.ctx.adjustmentBounds })(function() {
                    return {
                        block: 'b-adjustment-rates-fork',
                        mix: {
                            block: 'b-feed-filters-group',
                            elem: 'adjustment-rates'
                        },
                        lowerBound: this.ctx.adjustmentBounds.lower,
                        upperBound: this.ctx.adjustmentBounds.upper
                    };
                })
            )
        )
    )
);
