BEM.DOM.decl({ block: 'b-feed-filters-group', baseBlock: 'i-glue', implements: 'i-sortable-interface' }, {

    onSetMod: {

        js: function() {
            this.__base.apply(this, arguments);

            this._initGroupControls();

            // блоки расширяют i-glue и имеют публичную модель, которая используется при сортировке
            this._filters = this.findBlocksInside('b-group-feed-filter');
        }

    },

    /**
     * Сортирует элементы внутри данной группы
     * @param {String} field
     * @param {Boolean} reverse
     * @returns {BEM}
     */
    sort: function(field, reverse) {
        this._initModels();

        this.domElem.append(this._getSortedFragment(this._filters, field, reverse));

        return this;
    },

    /**
     * Инициализирует групповые контролы
     */
    _initGroupControls: function() {
        var models = this._getModels();

        this._size = models.length;

        this.findBlocksInside(this.elem('cell', 'type', 'multi-edit'), 'b-edit-phrase-price')
            .forEach(function(control) {
                control.initModels(models);
            }, this);
    },

    /**
     * Инициализируем модели для данной группы
     */
    _initModels: function() {
        if (this.models) return;

        this.models = this.model.getDM()
            .get('feed_filters')
            .filter(function(model) {
                return !model.get('is_deleted') && !model.get('is_suspended') && model.get('is_price_editable');
            })
            .map(function(model) {
                // подписка на удаление моделей группы
                model.on('destruct', function() {
                    this ._size--;

                    this._size || this.setMod('empty', 'yes');
                }, this);

                return model;
            }, this);
    },

    /**
     * Сортирует набор блоков elements по полю fieldName
     * @param {Array} elements
     * @param {String} fieldName
     * @param {Boolean} reverse - обратный/прямой вид сортировки
     * @returns {Object}
     */
    _getSortedFragment: function(elements, fieldName, reverse) {
        var orderDir = reverse ? -1 : 1;

        return elements
            .sort(function(a, b) {
                var val1 = a.model.get(fieldName),
                    val2 = b.model.get(fieldName),
                    isString = typeof val1 == 'string' && typeof val2 == 'string';

                if (isString) {
                    val1 = val1.toLowerCase();
                    val2 = val2.toLowerCase();
                }

                //для турции своя лексикографическая сортировка
                if (isString && u.consts('lang') == 'tr') return orderDir * u.sortTr(val1, val2);

                if (val1 < val2) return -orderDir;

                if (val1 > val2) return orderDir;

                return 0;
            })
            .reduce(function(fragment, block, i) {
                var domElem = block.domElem;

                block.toggleMod(domElem, 'first', 'yes', i == 0);

                fragment.appendChild(domElem.get(0));

                return fragment;
            }, document.createDocumentFragment());
    },

    /**
     * Возвращает массив моделей соответствующих фразам данной группы
     * @returns {BEM.MODEL[]}
     */
    _getModels: function() {
        this._initModels();

        return this.models;
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('init', 'b-feed-filter')
            .liveInitOnBlockInsideEvent('init', 'b-edit-phrase-price')
            .liveBindTo('inactive-toggle-button', 'click', function(e) {
                var button = this.findBlockOn(e.data.domElem, 'button');

                if (button && !button.isDisabled()) {
                    button.toggleMod('arrow', 'down', 'up');

                    this.toggleMod('hide-inactive', 'yes', 'no');
                }
            });
    }
});
